"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.useUiTracker = useUiTracker;
var _react = require("react");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Note: The usage_collection plugin will take care of sending this data to the telemetry server.
 * You can find the metrics that are collected by these hooks in Stack Telemetry.
 * Search the index `kibana-ui-counter`. You can filter for `eventName` and/or `appName`.
 */

function useUiTracker() {
  var _useKibana$services, _useKibana$services$u;
  const reportUiCounter = (_useKibana$services = (0, _public.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$u = _useKibana$services.usageCollection) === null || _useKibana$services$u === void 0 ? void 0 : _useKibana$services$u.reportUiCounter;
  const trackEvent = (0, _react.useMemo)(() => {
    return ({
      metric,
      metricType = _analytics.METRIC_TYPE.COUNT
    }) => {
      if (reportUiCounter) {
        reportUiCounter('infra_logs', metricType, metric);
      }
    };
  }, [reportUiCounter]);
  return trackEvent;
}