"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogEntryContextMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _log_entry_column = require("./log_entry_column");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_MENU_LABEL = _i18n.i18n.translate('xpack.logsShared.logEntryItemView.logEntryActionsMenuToolTip', {
  defaultMessage: 'View actions for line'
});
const LogEntryContextMenu = ({
  'aria-label': ariaLabel,
  isOpen,
  onOpen,
  onClose,
  items,
  externalItems
}) => {
  const closeMenuAndCall = (0, _react.useMemo)(() => {
    return callback => {
      return e => {
        onClose();
        callback === null || callback === void 0 ? void 0 : callback(e);
      };
    };
  }, [onClose]);
  const button = /*#__PURE__*/_react.default.createElement(ButtonWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraLogEntryContextMenuButton",
    size: "s",
    fill: true,
    "aria-label": ariaLabel || DEFAULT_MENU_LABEL,
    onClick: isOpen ? onClose : onOpen,
    minWidth: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "boxesHorizontal"
  })));
  const wrappedItems = (0, _react.useMemo)(() => {
    return items.map((item, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: i,
      onClick: closeMenuAndCall(item.onClick),
      href: item.href
    }, item.label)).concat((externalItems !== null && externalItems !== void 0 ? externalItems : []).map((item, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
      key: `external_${i}`
    }, item, {
      onClick: closeMenuAndCall(item.onClick)
    }))));
  }, [items, closeMenuAndCall, externalItems]);
  return /*#__PURE__*/_react.default.createElement(LogEntryContextMenuContent, null, /*#__PURE__*/_react.default.createElement(AbsoluteWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    closePopover: onClose,
    isOpen: isOpen,
    button: button,
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: wrappedItems
  }))));
};
exports.LogEntryContextMenu = LogEntryContextMenu;
const LogEntryContextMenuContent = (0, _styled.default)(_log_entry_column.LogEntryColumnContent)`
  overflow: hidden;
  user-select: none;
`;
const AbsoluteWrapper = _styled.default.div`
  position: absolute;
`;
const ButtonWrapper = _styled.default.div`
  transform: translate(-6px, -6px);
`;

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LogEntryContextMenu;