"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateControlPanels = exports.subscribeControlGroup = exports.initializeControlPanels = exports.getVisibleControlPanelsConfig = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _common = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeControlPanels = () => async context => {
  if (!('discoverStateContainer' in context)) return;
  return context.controlPanels ? constructControlPanelsWithDataViewId(context.discoverStateContainer, context.controlPanels) : undefined;
};
exports.initializeControlPanels = initializeControlPanels;
const subscribeControlGroup = () => context => send => {
  if (!('controlGroupAPI' in context)) return;
  if (!('discoverStateContainer' in context)) return;
  const {
    discoverStateContainer
  } = context;
  const filtersSubscription = context.controlGroupAPI.filters$.subscribe((newFilters = []) => {
    discoverStateContainer.internalState.transitions.setCustomFilters(newFilters);
    discoverStateContainer.actions.fetchData();
  });
  const inputSubscription = context.controlGroupAPI.getInput$().subscribe(({
    initialChildControlState: panels
  }) => {
    if (!(0, _fastDeepEqual.default)(panels, context.controlPanels)) {
      send({
        type: 'UPDATE_CONTROL_PANELS',
        controlPanels: panels
      });
    }
  });
  return () => {
    filtersSubscription.unsubscribe();
    inputSubscription.unsubscribe();
  };
};
exports.subscribeControlGroup = subscribeControlGroup;
const updateControlPanels = () => async (context, event) => {
  if (!('controlGroupAPI' in context)) return;
  if (!('discoverStateContainer' in context)) return;
  const {
    discoverStateContainer
  } = context;
  const newControlPanels = 'controlPanels' in event && event.controlPanels || context.controlPanels;
  if (!newControlPanels) return undefined;
  const controlPanelsWithId = constructControlPanelsWithDataViewId(discoverStateContainer, newControlPanels);
  context.controlGroupAPI.updateInput({
    initialChildControlState: controlPanelsWithId
  });
  return controlPanelsWithId;
};
exports.updateControlPanels = updateControlPanels;
const constructControlPanelsWithDataViewId = (stateContainer, newControlPanels) => {
  const dataView = stateContainer.internalState.getState().dataView;
  const validatedControlPanels = isValidState(newControlPanels) ? newControlPanels : getVisibleControlPanelsConfig(dataView);
  const controlsPanelsWithId = mergeDefaultPanelsWithControlPanels(dataView, validatedControlPanels);
  return controlsPanelsWithId;
};
const isValidState = state => {
  return Object.keys(state !== null && state !== void 0 ? state : {}).length > 0 && _common.ControlPanelRT.is(state);
};
const getVisibleControlPanels = dataView => _common.availableControlPanelFields.filter(panelKey => (dataView === null || dataView === void 0 ? void 0 : dataView.fields.getByName(panelKey)) !== undefined);
const getVisibleControlPanelsConfig = dataView => {
  return getVisibleControlPanels(dataView).reduce((panelsMap, panelKey) => {
    const config = _common.controlPanelConfigs[panelKey];
    return {
      ...panelsMap,
      [panelKey]: config
    };
  }, {});
};
exports.getVisibleControlPanelsConfig = getVisibleControlPanelsConfig;
const addDataViewIdToControlPanels = (controlPanels, dataViewId = '') => {
  return (0, _lodash.mapValues)(controlPanels, controlPanelConfig => ({
    ...controlPanelConfig,
    dataViewId
  }));
};
const mergeDefaultPanelsWithControlPanels = (dataView, urlPanels) => {
  // Get default panel configs from existing fields in data view
  const visiblePanels = getVisibleControlPanelsConfig(dataView);

  // Get list of panel which can be overridden to avoid merging additional config from url
  const existingKeys = Object.keys(visiblePanels);
  const controlPanelsToOverride = (0, _lodash.pick)(urlPanels, existingKeys);

  // Merge default and existing configs and add dataView.id to each of them
  return addDataViewIdToControlPanels({
    ...visiblePanels,
    ...controlPanelsToOverride
  }, dataView.id);
};