"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsExplorerPlugin = void 0;
var _logs_explorer = require("./components/logs_explorer");
var _lazy_create_controller = require("./controller/lazy_create_controller");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogsExplorerPlugin {
  constructor(context) {}
  setup(core, plugins) {
    return {};
  }
  start(core, plugins) {
    const LogsExplorer = (0, _logs_explorer.createLogsExplorer)({
      core,
      plugins
    });
    const createLogsExplorerController = (0, _lazy_create_controller.createLogsExplorerControllerLazyFactory)({
      core,
      plugins
    });
    return {
      LogsExplorer,
      createLogsExplorerController
    };
  }
}
exports.LogsExplorerPlugin = LogsExplorerPlugin;