"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomUnifiedHistogram = void 0;
var _public = require("@kbn/unified-search-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isClickTriggerEvent = e => {
  return Array.isArray(e.data) && 'column' in e.data[0];
};
const isMultiValueTriggerEvent = e => {
  return Array.isArray(e.data) && 'cells' in e.data[0];
};
const createCustomUnifiedHistogram = data => {
  return {
    id: 'unified_histogram',
    onFilter: async eventData => {
      eventData.preventDefault();
      let filters;
      if (isClickTriggerEvent(eventData)) {
        filters = await data.actions.createFiltersFromValueClickAction(eventData);
      } else if (isMultiValueTriggerEvent(eventData)) {
        filters = await data.actions.createFiltersFromMultiValueClickAction(eventData);
      }
      if (filters && filters.length > 0) {
        data.query.filterManager.addFilters(filters);
      }
    },
    onBrushEnd: eventData => {
      eventData.preventDefault();
      const [from, to] = eventData.range;
      data.query.timefilter.timefilter.setTime({
        from: new Date(from).toISOString(),
        to: new Date(to).toISOString(),
        mode: 'absolute'
      });
    },
    withDefaultActions: false,
    disabledActions: [_public.ACTION_GLOBAL_APPLY_FILTER]
  };
};
exports.createCustomUnifiedHistogram = createCustomUnifiedHistogram;