"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/controls-plugin/public");
var _use_control_panels = require("../hooks/use_control_panels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_SOURCE_FILTERS_CUSTOMIZATION_ID = 'dataSourceFiltersCustomization';
const CustomDataSourceFilters = ({
  logsExplorerControllerStateService,
  data
}) => {
  const {
    getInitialState,
    setControlGroupAPI,
    query,
    filters,
    timeRange
  } = (0, _use_control_panels.useControlPanels)(logsExplorerControllerStateService, data);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": DATA_SOURCE_FILTERS_CUSTOMIZATION_ID
  }, /*#__PURE__*/_react.default.createElement(_public.ControlGroupRenderer, {
    onApiAvailable: setControlGroupAPI,
    getCreationOptions: getInitialState,
    query: query,
    filters: filters !== null && filters !== void 0 ? filters : [],
    timeRange: timeRange
  }));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = CustomDataSourceFilters;
module.exports = exports.default;