"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchControls = ({
  search,
  onSearch,
  onSort,
  isLoading,
  filterComponent
}) => {
  const handleNameChange = event => {
    const newSearch = {
      ...search,
      name: event.target.value
    };
    onSearch(newSearch);
  };
  const handleSortChange = id => {
    const newSearch = {
      ...search,
      sortOrder: id
    };
    onSort(newSearch);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    css: {
      width: _constants.DATA_SOURCE_SELECTOR_WIDTH
    },
    "data-test-subj": "dataSourceSelectorSearchControls"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "logsExplorerSearchControlsFieldSearch",
    compressed: true,
    incremental: true,
    value: search.name,
    onChange: handleNameChange,
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isIconOnly: true,
    buttonSize: "compressed",
    options: _constants.sortOptions,
    legend: _constants.sortOrdersLabel,
    idSelected: search.sortOrder,
    onChange: handleSortChange
  })))), filterComponent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, filterComponent)));
};
exports.SearchControls = SearchControls;