"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewMenuItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataViewMenuItem = ({
  dataView,
  isAvailable
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (isAvailable) {
    return /*#__PURE__*/_react.default.createElement("span", null, dataView.name);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
          margin-right: ${euiTheme.size.s};
        `
  }, dataView.name), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _constants.openDiscoverLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    color: "subdued"
  })));
};
exports.DataViewMenuItem = DataViewMenuItem;