"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataSourceSelector = void 0;
var _react = require("react");
var _react2 = require("@xstate/react");
var _data_source_selection = require("../../../../common/data_source_selection");
var _state_machine = require("./state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataSourceSelector = ({
  initialContext,
  onDataViewsSearch,
  onDataViewsFilter,
  onDataViewsSort,
  onIntegrationsLoadMore,
  onIntegrationsReload,
  onIntegrationsSearch,
  onIntegrationsSort,
  onIntegrationsStreamsSearch,
  onIntegrationsStreamsSort,
  onSelectionChange,
  onUncategorizedSearch,
  onUncategorizedSort,
  onUncategorizedReload
}) => {
  const dataSourceSelectorStateService = (0, _react2.useInterpret)(() => (0, _state_machine.createDataSourceSelectorStateMachine)({
    initialContext,
    onDataViewsSearch,
    onDataViewsFilter,
    onDataViewsSort,
    onIntegrationsLoadMore,
    onIntegrationsReload,
    onIntegrationsSearch,
    onIntegrationsSort,
    onIntegrationsStreamsSearch,
    onIntegrationsStreamsSort,
    onSelectionChange,
    onUncategorizedSearch,
    onUncategorizedSort,
    onUncategorizedReload
  }));
  const isOpen = (0, _react2.useSelector)(dataSourceSelectorStateService, state => state.matches('popover.open'));
  const panelId = (0, _react2.useSelector)(dataSourceSelectorStateService, state => state.context.panelId);
  const search = (0, _react2.useSelector)(dataSourceSelectorStateService, state => state.context.search);
  const dataViewsFilter = (0, _react2.useSelector)(dataSourceSelectorStateService, state => state.context.dataViewsFilter);
  const selection = (0, _react2.useSelector)(dataSourceSelectorStateService, state => state.context.selection);
  const tabId = (0, _react2.useSelector)(dataSourceSelectorStateService, state => state.context.tabId);
  const switchToIntegrationsTab = (0, _react.useCallback)(() => dataSourceSelectorStateService.send({
    type: 'SWITCH_TO_INTEGRATIONS_TAB'
  }), [dataSourceSelectorStateService]);
  const switchToUncategorizedTab = (0, _react.useCallback)(() => dataSourceSelectorStateService.send({
    type: 'SWITCH_TO_UNCATEGORIZED_TAB'
  }), [dataSourceSelectorStateService]);
  const switchToDataViewsTab = (0, _react.useCallback)(() => dataSourceSelectorStateService.send({
    type: 'SWITCH_TO_DATA_VIEWS_TAB'
  }), [dataSourceSelectorStateService]);
  const changePanel = (0, _react.useCallback)(panelDetails => dataSourceSelectorStateService.send({
    type: 'CHANGE_PANEL',
    panelId: panelDetails.panelId
  }), [dataSourceSelectorStateService]);
  const scrollToIntegrationsBottom = (0, _react.useCallback)(() => dataSourceSelectorStateService.send({
    type: 'SCROLL_TO_INTEGRATIONS_BOTTOM'
  }), [dataSourceSelectorStateService]);
  const searchByName = (0, _react.useCallback)(params => dataSourceSelectorStateService.send({
    type: 'SEARCH_BY_NAME',
    search: params
  }), [dataSourceSelectorStateService]);
  const filterByType = (0, _react.useCallback)(params => dataSourceSelectorStateService.send({
    type: 'FILTER_BY_TYPE',
    filter: params
  }), [dataSourceSelectorStateService]);
  const selectAllLogs = (0, _react.useCallback)(() => dataSourceSelectorStateService.send({
    type: 'SELECT_ALL_LOGS'
  }), [dataSourceSelectorStateService]);
  const selectDataset = (0, _react.useCallback)(dataset => dataSourceSelectorStateService.send({
    type: 'SELECT_DATASET',
    selection: dataset
  }), [dataSourceSelectorStateService]);
  const selectDataView = (0, _react.useCallback)(dataViewDescriptor => dataSourceSelectorStateService.send({
    type: 'SELECT_DATA_VIEW',
    selection: dataViewDescriptor
  }), [dataSourceSelectorStateService]);
  const sortByOrder = (0, _react.useCallback)(params => dataSourceSelectorStateService.send({
    type: 'SORT_BY_ORDER',
    search: params
  }), [dataSourceSelectorStateService]);
  const closePopover = (0, _react.useCallback)(() => dataSourceSelectorStateService.send({
    type: 'CLOSE'
  }), [dataSourceSelectorStateService]);
  const togglePopover = (0, _react.useCallback)(() => dataSourceSelectorStateService.send({
    type: 'TOGGLE'
  }), [dataSourceSelectorStateService]);
  return {
    // Data
    panelId,
    search,
    dataViewsFilter,
    selection,
    tabId,
    // Flags
    isOpen,
    isAllMode: (0, _data_source_selection.isAllDatasetSelection)(selection),
    // Actions
    changePanel,
    closePopover,
    scrollToIntegrationsBottom,
    searchByName,
    filterByType,
    selectAllLogs,
    selectDataset,
    selectDataView,
    sortByOrder,
    switchToIntegrationsTab,
    switchToUncategorizedTab,
    switchToDataViewsTab,
    togglePopover
  };
};
exports.useDataSourceSelector = useDataSourceSelector;