"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  isAllDatasetSelection: true,
  isSingleDatasetSelection: true,
  isUnresolvedDatasetSelection: true,
  isDataViewSelection: true,
  isDatasetSelection: true,
  isDataSourceSelection: true
};
exports.isUnresolvedDatasetSelection = exports.isSingleDatasetSelection = exports.isDatasetSelection = exports.isDataViewSelection = exports.isDataSourceSelection = exports.isAllDatasetSelection = void 0;
var _all_dataset_selection = require("./all_dataset_selection");
Object.keys(_all_dataset_selection).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _all_dataset_selection[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _all_dataset_selection[key];
    }
  });
});
var _data_view_selection = require("./data_view_selection");
Object.keys(_data_view_selection).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _data_view_selection[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _data_view_selection[key];
    }
  });
});
var _single_dataset_selection = require("./single_dataset_selection");
Object.keys(_single_dataset_selection).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _single_dataset_selection[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _single_dataset_selection[key];
    }
  });
});
var _unresolved_dataset_selection = require("./unresolved_dataset_selection");
Object.keys(_unresolved_dataset_selection).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _unresolved_dataset_selection[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _unresolved_dataset_selection[key];
    }
  });
});
var _hydrate_data_source_selection = require("./hydrate_data_source_selection");
Object.keys(_hydrate_data_source_selection).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _hydrate_data_source_selection[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _hydrate_data_source_selection[key];
    }
  });
});
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAllDatasetSelection = input => {
  return input instanceof _all_dataset_selection.AllDatasetSelection;
};
exports.isAllDatasetSelection = isAllDatasetSelection;
const isSingleDatasetSelection = input => {
  return input instanceof _single_dataset_selection.SingleDatasetSelection;
};
exports.isSingleDatasetSelection = isSingleDatasetSelection;
const isUnresolvedDatasetSelection = input => {
  return input instanceof _unresolved_dataset_selection.UnresolvedDatasetSelection;
};
exports.isUnresolvedDatasetSelection = isUnresolvedDatasetSelection;
const isDataViewSelection = input => {
  return input instanceof _data_view_selection.DataViewSelection;
};
exports.isDataViewSelection = isDataViewSelection;
const isDatasetSelection = input => {
  return isAllDatasetSelection(input) || isSingleDatasetSelection(input) || isUnresolvedDatasetSelection(input);
};
exports.isDatasetSelection = isDatasetSelection;
const isDataSourceSelection = input => {
  return isDatasetSelection(input) || isDataViewSelection(input);
};
exports.isDataSourceSelection = isDataSourceSelection;