"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBucketSizeFromTimeRangeAndBucketCount = getBucketSizeFromTimeRangeAndBucketCount;
exports.getLogErrorRate = getLogErrorRate;
exports.getLogRatePerMinute = getLogRatePerMinute;
var _moment = _interopRequireDefault(require("moment/moment"));
var _calculateAuto = require("@kbn/calculate-auto");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getBucketSizeFromTimeRangeAndBucketCount(timeFrom, timeTo, numBuckets) {
  var _calculateAuto$near$a, _calculateAuto$near;
  const duration = _moment.default.duration(timeTo - timeFrom, 'ms');
  return Math.max((_calculateAuto$near$a = (_calculateAuto$near = _calculateAuto.calculateAuto.near(numBuckets, duration)) === null || _calculateAuto$near === void 0 ? void 0 : _calculateAuto$near.asSeconds()) !== null && _calculateAuto$near$a !== void 0 ? _calculateAuto$near$a : 0, 60);
}
function getLogRatePerMinute({
  logCount,
  timeFrom,
  timeTo
}) {
  const durationAsMinutes = (timeTo - timeFrom) / 1000 / 60;
  return logCount / durationAsMinutes;
}
function getLogErrorRate({
  logCount,
  logErrorCount = 0
}) {
  return logErrorCount / logCount;
}