"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinksEmbeddableFactory = exports.LinksContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _content_management = require("../../common/content_management");
var _dashboard_link_component = require("../components/dashboard_link/dashboard_link_component");
var _external_link_component = require("../components/external_link/external_link_component");
var _common = require("../../common");
var _persistable_state = require("../../common/persistable_state");
require("../components/links_component.scss");
var _content_management2 = require("../content_management");
var _resolve_links = require("../lib/resolve_links");
var _deserialize_from_library = require("../lib/deserialize_from_library");
var _serialize_attributes = require("../lib/serialize_attributes");
var _compatibility_check = require("../actions/compatibility_check");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const LinksContext = exports.LinksContext = /*#__PURE__*/(0, _react.createContext)(null);
const getLinksEmbeddableFactory = () => {
  const linksEmbeddableFactory = {
    type: _content_management.CONTENT_ID,
    deserializeState: async serializedState => {
      var _serializedState$refe, _attributesWithInject;
      // Clone the state to avoid an object not extensible error when injecting references
      const state = (0, _lodash.cloneDeep)(serializedState.rawState);
      const {
        title,
        description,
        hidePanelTitles
      } = serializedState.rawState;
      if ((0, _deserialize_from_library.linksSerializeStateIsByReference)(state)) {
        const linksSavedObject = await _content_management2.linksClient.get(state.savedObjectId);
        const runtimeState = await (0, _deserialize_from_library.deserializeLinksSavedObject)(linksSavedObject.item);
        return {
          ...runtimeState,
          title,
          description,
          hidePanelTitles
        };
      }
      const {
        attributes: attributesWithInjectedIds
      } = (0, _persistable_state.injectReferences)({
        attributes: state.attributes,
        references: (_serializedState$refe = serializedState.references) !== null && _serializedState$refe !== void 0 ? _serializedState$refe : []
      });
      const resolvedLinks = await (0, _resolve_links.resolveLinks)((_attributesWithInject = attributesWithInjectedIds.links) !== null && _attributesWithInject !== void 0 ? _attributesWithInject : []);
      return {
        title,
        description,
        hidePanelTitles,
        links: resolvedLinks,
        layout: attributesWithInjectedIds.layout,
        defaultPanelTitle: attributesWithInjectedIds.title,
        defaultPanelDescription: attributesWithInjectedIds.description
      };
    },
    buildEmbeddable: async (state, buildApi, uuid, parentApi) => {
      const blockingError$ = new _rxjs.BehaviorSubject(state.error);
      if (!(0, _compatibility_check.isParentApiCompatible)(parentApi)) blockingError$.next(new _public.PanelIncompatibleError());
      const links$ = new _rxjs.BehaviorSubject(state.links);
      const layout$ = new _rxjs.BehaviorSubject(state.layout);
      const defaultTitle$ = new _rxjs.BehaviorSubject(state.defaultPanelTitle);
      const defaultDescription$ = new _rxjs.BehaviorSubject(state.defaultPanelDescription);
      const savedObjectId$ = new _rxjs.BehaviorSubject(state.savedObjectId);
      const isByReference = Boolean(state.savedObjectId);
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(state);
      const serializeLinksState = (byReference, newId) => {
        if (byReference) {
          const linksByReferenceState = {
            savedObjectId: newId !== null && newId !== void 0 ? newId : state.savedObjectId,
            ...titleManager.serialize()
          };
          return {
            rawState: linksByReferenceState,
            references: []
          };
        }
        const runtimeState = api.snapshotRuntimeState();
        const {
          attributes,
          references
        } = (0, _serialize_attributes.serializeLinksAttributes)(runtimeState);
        const linksByValueState = {
          attributes,
          ...titleManager.serialize()
        };
        return {
          rawState: linksByValueState,
          references
        };
      };
      const api = buildApi({
        ...titleManager.api,
        blockingError$,
        defaultTitle$,
        defaultDescription$,
        isEditingEnabled: () => Boolean(blockingError$.value === undefined),
        getTypeDisplayName: () => _common.DISPLAY_NAME,
        serializeState: () => serializeLinksState(isByReference),
        saveToLibrary: async newTitle => {
          defaultTitle$.next(newTitle);
          const runtimeState = api.snapshotRuntimeState();
          const {
            attributes,
            references
          } = (0, _serialize_attributes.serializeLinksAttributes)(runtimeState);
          const {
            item: {
              id
            }
          } = await _content_management2.linksClient.create({
            data: {
              ...attributes,
              title: newTitle
            },
            options: {
              references
            }
          });
          return id;
        },
        getSerializedStateByValue: () => serializeLinksState(false),
        getSerializedStateByReference: newId => serializeLinksState(true, newId),
        canLinkToLibrary: async () => !isByReference,
        canUnlinkFromLibrary: async () => isByReference,
        checkForDuplicateTitle: async (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => {
          await (0, _content_management2.checkForDuplicateTitle)({
            title: newTitle,
            copyOnSave: false,
            lastSavedTitle: '',
            isTitleDuplicateConfirmed,
            onTitleDuplicate
          });
        },
        onEdit: async () => {
          const {
            openEditorFlyout
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('../editor/open_editor_flyout')));
          const newState = await openEditorFlyout({
            initialState: api.snapshotRuntimeState(),
            parentDashboard: parentApi
          });
          if (!newState) return;

          // if the by reference state has changed during this edit, reinitialize the panel.
          const nextIsByReference = Boolean(newState === null || newState === void 0 ? void 0 : newState.savedObjectId);
          if (nextIsByReference !== isByReference) {
            var _api$parentApi;
            const serializedState = serializeLinksState(nextIsByReference, newState === null || newState === void 0 ? void 0 : newState.savedObjectId);
            serializedState.rawState.title = newState.title;
            (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.replacePanel(api.uuid, {
              serializedState,
              panelType: api.type
            });
            return;
          }
          links$.next(newState.links);
          layout$.next(newState.layout);
          defaultTitle$.next(newState.defaultPanelTitle);
          defaultDescription$.next(newState.defaultPanelDescription);
        }
      }, {
        ...titleManager.comparators,
        links: [links$, nextLinks => links$.next(nextLinks !== null && nextLinks !== void 0 ? nextLinks : [])],
        layout: [layout$, nextLayout => layout$.next(nextLayout !== null && nextLayout !== void 0 ? nextLayout : _content_management.LINKS_VERTICAL_LAYOUT)],
        error: [blockingError$, nextError => blockingError$.next(nextError)],
        defaultPanelDescription: [defaultDescription$, nextDescription => defaultDescription$.next(nextDescription)],
        defaultPanelTitle: [defaultTitle$, nextTitle => defaultTitle$.next(nextTitle)],
        savedObjectId: [savedObjectId$, val => savedObjectId$.next(val)]
      });
      const Component = () => {
        const [links, layout] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)(links$, layout$);
        const linkItems = (0, _react.useMemo)(() => {
          if (!links) return {};
          return links.reduce((prev, currentLink) => {
            return {
              ...prev,
              [currentLink.id]: {
                id: currentLink.id,
                content: currentLink.type === _content_management.DASHBOARD_LINK_TYPE ? /*#__PURE__*/_react.default.createElement(_dashboard_link_component.DashboardLinkComponent, {
                  key: currentLink.id,
                  link: currentLink,
                  layout: layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT,
                  parentApi: parentApi
                }) : /*#__PURE__*/_react.default.createElement(_external_link_component.ExternalLinkComponent, {
                  key: currentLink.id,
                  link: currentLink,
                  layout: layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT
                })
              }
            };
          }, {});
        }, [links, layout]);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          className: `linksComponent ${layout === _content_management.LINKS_HORIZONTAL_LAYOUT ? 'eui-xScroll' : 'eui-yScroll'}`,
          paddingSize: "xs",
          "data-shared-item": true,
          "data-rendering-count": 1,
          "data-test-subj": "links--component",
          borderRadius: "none"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
          maxWidth: false,
          className: `${layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT}LayoutWrapper`,
          "data-test-subj": "links--component--listGroup"
        }, links === null || links === void 0 ? void 0 : links.map(link => linkItems[link.id].content)));
      };
      return {
        api,
        Component
      };
    }
  };
  return linksEmbeddableFactory;
};
exports.getLinksEmbeddableFactory = getLinksEmbeddableFactory;