"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LinksStrings = exports.LinksStrings = {
  getDescription: () => _i18n.i18n.translate('links.description', {
    defaultMessage: 'Use links to navigate to commonly used dashboards and websites.'
  }),
  embeddable: {
    getUnsupportedLinkTypeError: () => _i18n.i18n.translate('links.embeddable.unsupportedLinkTypeError', {
      defaultMessage: 'Unsupported link type'
    })
  },
  editor: {
    getAddButtonLabel: () => _i18n.i18n.translate('links.editor.addButtonLabel', {
      defaultMessage: 'Add link'
    }),
    getUpdateButtonLabel: () => _i18n.i18n.translate('links.editor.updateButtonLabel', {
      defaultMessage: 'Update link'
    }),
    getEditLinkTitle: label => _i18n.i18n.translate('links.editor.editLinkTitle.hasLabel', {
      defaultMessage: 'Edit {label} link',
      values: {
        label: label !== null && label !== void 0 ? label : ''
      }
    }),
    getDeleteLinkTitle: label => _i18n.i18n.translate('links.editor.deleteLinkTitle', {
      defaultMessage: 'Delete {label} link',
      values: {
        label: label !== null && label !== void 0 ? label : ''
      }
    }),
    getCancelButtonLabel: () => _i18n.i18n.translate('links.editor.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    panelEditor: {
      getLinksTitle: () => _i18n.i18n.translate('links.panelEditor.linksTitle', {
        defaultMessage: 'Links'
      }),
      getEmptyLinksMessage: () => _i18n.i18n.translate('links.panelEditor.emptyLinksMessage', {
        defaultMessage: "You haven't added any links yet."
      }),
      getEmptyLinksTooltip: () => _i18n.i18n.translate('links.panelEditor.emptyLinksTooltip', {
        defaultMessage: 'Add one or more links.'
      }),
      getCreateFlyoutTitle: () => _i18n.i18n.translate('links.panelEditor.createFlyoutTitle', {
        defaultMessage: 'Create links panel'
      }),
      getEditFlyoutTitle: () => _i18n.i18n.translate('links.panelEditor.editFlyoutTitle', {
        defaultMessage: 'Edit links panel'
      }),
      getSaveButtonLabel: () => _i18n.i18n.translate('links.panelEditor.saveButtonLabel', {
        defaultMessage: 'Save'
      }),
      getSaveToLibrarySwitchLabel: () => _i18n.i18n.translate('links.panelEditor.saveToLibrarySwitchLabel', {
        defaultMessage: 'Save to library'
      }),
      getSaveToLibrarySwitchTooltip: () => _i18n.i18n.translate('links.panelEditor.saveToLibrarySwitchTooltip', {
        defaultMessage: 'Save this links panel to the library so you can easily add it to other dashboards.'
      }),
      getTitleInputLabel: () => _i18n.i18n.translate('links.panelEditor.titleInputLabel', {
        defaultMessage: 'Title'
      }),
      getBrokenDashboardLinkAriaLabel: () => _i18n.i18n.translate('links.panelEditor.brokenDashboardLinkAriaLabel', {
        defaultMessage: 'Broken dashboard link'
      }),
      getDragHandleAriaLabel: () => _i18n.i18n.translate('links.panelEditor.dragHandleAriaLabel', {
        defaultMessage: 'Link drag handle'
      }),
      getLayoutSettingsTitle: () => _i18n.i18n.translate('links.panelEditor.layoutSettingsTitle', {
        defaultMessage: 'Layout'
      }),
      getLayoutSettingsLegend: () => _i18n.i18n.translate('links.panelEditor.layoutSettingsLegend', {
        defaultMessage: 'Choose how to display your links.'
      }),
      getHorizontalLayoutLabel: () => _i18n.i18n.translate('links.editor.horizontalLayout', {
        defaultMessage: 'Horizontal'
      }),
      getVerticalLayoutLabel: () => _i18n.i18n.translate('links.editor.verticalLayout', {
        defaultMessage: 'Vertical'
      }),
      getErrorDuringSaveToastTitle: () => _i18n.i18n.translate('links.editor.unableToSaveToastTitle', {
        defaultMessage: 'Error saving links panel'
      })
    },
    linkEditor: {
      getGoBackAriaLabel: () => _i18n.i18n.translate('links.linkEditor.goBackAriaLabel', {
        defaultMessage: 'Go back to panel editor.'
      }),
      getLinkTypePickerLabel: () => _i18n.i18n.translate('links.linkEditor.linkTypeFormLabel', {
        defaultMessage: 'Go to'
      }),
      getLinkDestinationLabel: () => _i18n.i18n.translate('links.linkEditor.linkDestinationLabel', {
        defaultMessage: 'Choose destination'
      }),
      getLinkTextLabel: () => _i18n.i18n.translate('links.linkEditor.linkTextLabel', {
        defaultMessage: 'Text'
      }),
      getLinkTextPlaceholder: () => _i18n.i18n.translate('links.linkEditor.linkTextPlaceholder', {
        defaultMessage: 'Enter text for link'
      }),
      getLinkOptionsLabel: () => _i18n.i18n.translate('links.linkEditor.linkOptionsLabel', {
        defaultMessage: 'Options'
      })
    }
  }
};