"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksEditorEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _links_strings = require("../links_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LinksEditorEmptyPrompt = ({
  addLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "links--panelEditor--emptyPrompt"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "plain",
    hasShadow: false,
    paddingSize: "none",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _links_strings.LinksStrings.editor.panelEditor.getEmptyLinksMessage()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: addLink,
      iconType: "plusInCircle",
      "data-test-subj": "links--panelEditor--addLinkBtn"
    }, _links_strings.LinksStrings.editor.getAddButtonLabel()))
  })));
};
exports.LinksEditorEmptyPrompt = LinksEditorEmptyPrompt;