"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _content_management = require("../../../common/content_management");
var _links_editor_tools = require("../../editor/links_editor_tools");
var _open_link_editor_flyout = require("../../editor/open_link_editor_flyout");
var _kibana_services = require("../../services/kibana_services");
var _links_strings = require("../links_strings");
var _links_editor_empty_prompt = require("./links_editor_empty_prompt");
var _links_editor_single_link = require("./links_editor_single_link");
var _tooltip_wrapper = require("../tooltip_wrapper");
require("./links_editor.scss");
var _resolve_links = require("../../lib/resolve_links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const layoutOptions = [{
  id: _content_management.LINKS_VERTICAL_LAYOUT,
  label: _links_strings.LinksStrings.editor.panelEditor.getVerticalLayoutLabel(),
  'data-test-subj': `links--panelEditor--${_content_management.LINKS_VERTICAL_LAYOUT}LayoutBtn`
}, {
  id: _content_management.LINKS_HORIZONTAL_LAYOUT,
  label: _links_strings.LinksStrings.editor.panelEditor.getHorizontalLayoutLabel(),
  'data-test-subj': `links--panelEditor--${_content_management.LINKS_HORIZONTAL_LAYOUT}LayoutBtn`
}];
const LinksEditor = ({
  onSaveToLibrary,
  onAddToDashboard,
  onClose,
  initialLinks,
  initialLayout,
  parentDashboardId,
  isByReference,
  flyoutId
}) => {
  const toasts = _kibana_services.coreServices.notifications.toasts;
  const isMounted = (0, _useMountedState.default)();
  const editLinkFlyoutRef = (0, _react.useRef)(null);
  const [currentLayout, setCurrentLayout] = (0, _react.useState)(initialLayout !== null && initialLayout !== void 0 ? initialLayout : _content_management.LINKS_VERTICAL_LAYOUT);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [orderedLinks, setOrderedLinks] = (0, _react.useState)([]);
  const [saveByReference, setSaveByReference] = (0, _react.useState)(isByReference);
  const isEditingExisting = initialLinks || isByReference;
  (0, _react.useEffect)(() => {
    if (!initialLinks) {
      setOrderedLinks([]);
      return;
    }
    setOrderedLinks((0, _resolve_links.getOrderedLinkList)(initialLinks));
  }, [initialLinks]);
  const onDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    if (source && destination) {
      const newList = (0, _eui.euiDragDropReorder)(orderedLinks, source.index, destination.index).map((link, i) => {
        return {
          ...link,
          order: i
        };
      });
      setOrderedLinks(newList);
    }
  }, [orderedLinks]);
  const addOrEditLink = (0, _react.useCallback)(async linkToEdit => {
    const newLink = await (0, _open_link_editor_flyout.openLinkEditorFlyout)({
      parentDashboardId,
      link: linkToEdit,
      mainFlyoutId: flyoutId,
      ref: editLinkFlyoutRef
    });
    if (newLink) {
      if (linkToEdit) {
        setOrderedLinks(orderedLinks.map(link => {
          if (link.id === linkToEdit.id) {
            return {
              ...newLink,
              order: linkToEdit.order
            };
          }
          return link;
        }));
      } else {
        setOrderedLinks([...orderedLinks, {
          ...newLink,
          order: orderedLinks.length
        }]);
      }
    }
  }, [editLinkFlyoutRef, orderedLinks, parentDashboardId, flyoutId]);
  const hasZeroLinks = (0, _react.useMemo)(() => {
    return orderedLinks.length === 0;
  }, [orderedLinks]);
  const deleteLink = (0, _react.useCallback)(linkId => {
    setOrderedLinks(orderedLinks.filter(link => {
      return link.id !== linkId;
    }));
    (0, _links_editor_tools.focusMainFlyout)(flyoutId);
  }, [orderedLinks, flyoutId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    ref: editLinkFlyoutRef
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "links--panelEditor--title"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isEditingExisting ? _links_strings.LinksStrings.editor.panelEditor.getEditFlyoutTitle() : _links_strings.LinksStrings.editor.panelEditor.getCreateFlyoutTitle()))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody
  // EUI TODO: We need to set transform to 'none' to avoid drag/drop issues in the flyout caused by the
  // `transform: translateZ(0)` workaround for the mask image bug in Chromium.
  // https://github.com/elastic/eui/pull/7855.
  , {
    css: {
      '.euiFlyoutBody__overflow': {
        transform: 'none'
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.panelEditor.getLayoutSettingsTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: layoutOptions,
    buttonSize: "compressed",
    idSelected: currentLayout,
    onChange: id => {
      setCurrentLayout(id);
    },
    legend: _links_strings.LinksStrings.editor.panelEditor.getLayoutSettingsLegend()
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.panelEditor.getLinksTitle()
  }, /*#__PURE__*/_react.default.createElement("div", null, hasZeroLinks ? /*#__PURE__*/_react.default.createElement(_links_editor_empty_prompt.LinksEditorEmptyPrompt, {
    addLink: () => addOrEditLink()
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    className: "linksDroppableLinksArea",
    droppableId: "linksDroppableLinksArea",
    "data-test-subj": "links--panelEditor--linksAreaDroppable"
  }, orderedLinks.map((link, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    index: idx,
    key: link.id,
    draggableId: link.id,
    customDragHandle: true,
    hasInteractiveChildren: true,
    "data-test-subj": `links--panelEditor--draggableLink`
  }, provided => {
    var _provided$dragHandleP;
    return /*#__PURE__*/_react.default.createElement(_links_editor_single_link.LinksEditorSingleLink, {
      link: link,
      editLink: () => addOrEditLink(link),
      deleteLink: () => deleteLink(link.id),
      dragHandleProps: (_provided$dragHandleP = provided.dragHandleProps) !== null && _provided$dragHandleP !== void 0 ? _provided$dragHandleP : undefined // casting `null` to `undefined`
    });
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: "plusInCircle",
    onClick: () => addOrEditLink(),
    "data-test-subj": "links--panelEditor--addLinkBtn"
  }, _links_strings.LinksStrings.editor.getAddButtonLabel())))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "links--panelEditor--closeBtn"
  }, _links_strings.LinksStrings.editor.getCancelButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, !initialLinks || !isByReference ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    condition: !hasZeroLinks,
    tooltipContent: _links_strings.LinksStrings.editor.panelEditor.getSaveToLibrarySwitchTooltip(),
    "data-test-subj": "links--panelEditor--saveByReferenceTooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _links_strings.LinksStrings.editor.panelEditor.getSaveToLibrarySwitchLabel(),
    checked: saveByReference,
    disabled: hasZeroLinks,
    onChange: () => setSaveByReference(!saveByReference),
    "data-test-subj": "links--panelEditor--saveByReferenceSwitch"
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    condition: hasZeroLinks,
    tooltipContent: _links_strings.LinksStrings.editor.panelEditor.getEmptyLinksTooltip(),
    "data-test-id": 'links--panelEditor--saveBtnTooltip'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: isSaving,
    disabled: hasZeroLinks,
    "data-test-subj": 'links--panelEditor--saveBtn',
    onClick: async () => {
      if (saveByReference) {
        setIsSaving(true);
        onSaveToLibrary(orderedLinks, currentLayout).catch(e => {
          toasts.addError(e, {
            title: _links_strings.LinksStrings.editor.panelEditor.getErrorDuringSaveToastTitle()
          });
        }).finally(() => {
          if (isMounted()) {
            setIsSaving(false);
          }
        });
      } else {
        onAddToDashboard(orderedLinks, currentLayout);
      }
    }
  }, _links_strings.LinksStrings.editor.panelEditor.getSaveButtonLabel()))))))));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = exports.default = LinksEditor;
module.exports = exports.default;