"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCreateLinksPanelAction = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _common = require("../../common");
var _kibana_services = require("../services/kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ADD_LINKS_PANEL_ACTION_ID = 'create_links_panel';
const registerCreateLinksPanelAction = () => {
  _kibana_services.uiActions.registerAction({
    id: ADD_LINKS_PANEL_ACTION_ID,
    getIconType: () => _common.APP_ICON,
    order: 10,
    isCompatible: async ({
      embeddable
    }) => {
      const {
        isParentApiCompatible
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./compatibility_check')));
      return isParentApiCompatible(embeddable);
    },
    execute: async ({
      embeddable
    }) => {
      const {
        isParentApiCompatible
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./compatibility_check')));
      if (!isParentApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
      const {
        openEditorFlyout
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../editor/open_editor_flyout')));
      const runtimeState = await openEditorFlyout({
        parentDashboard: embeddable
      });
      if (!runtimeState) return;
      await embeddable.addNewPanel({
        panelType: _common.CONTENT_ID,
        initialState: runtimeState
      });
    },
    grouping: [_public2.ADD_PANEL_ANNOTATION_GROUP],
    getDisplayName: () => _common.APP_NAME
  });
  _kibana_services.uiActions.attachAction(_public.ADD_PANEL_TRIGGER, ADD_LINKS_PANEL_ACTION_ID);
};
exports.registerCreateLinksPanelAction = registerCreateLinksPanelAction;