"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInfoRoute = registerInfoRoute;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerInfoRoute(router) {
  router.get({
    path: '/api/licensing/info',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: false
  }, async (context, request, response) => {
    return response.ok({
      body: (await context.licensing).license
    });
  });
}