"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountExpiredBanner = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpiredBanner = props => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  iconType: "help",
  color: "warning",
  "data-test-subj": "licenseExpiredBanner",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.licensing.welcomeBanner.licenseIsExpiredTitle",
    defaultMessage: "Your {licenseType} license is expired",
    values: {
      licenseType: props.type
    }
  })
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.licensing.welcomeBanner.licenseIsExpiredDescription",
  defaultMessage: "Contact your administrator or {updateYourLicenseLinkText} directly.",
  values: {
    updateYourLicenseLinkText: /*#__PURE__*/_react.default.createElement("a", {
      href: props.uploadUrl
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licensing.welcomeBanner.licenseIsExpiredDescription.updateYourLicenseLinkText",
      defaultMessage: "update your license"
    }))
  }
}));
const mountExpiredBanner = ({
  type,
  uploadUrl,
  ...startServices
}) => (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(ExpiredBanner, {
  type: type,
  uploadUrl: uploadUrl
}), startServices);
exports.mountExpiredBanner = mountExpiredBanner;