"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AxisSettingsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _chartIcons = require("@kbn/chart-icons");
var _visualizationUtils = require("@kbn/visualization-utils");
var _state_helpers = require("../state_helpers");
var _shared_components = require("../../../shared_components");
require("./axis_settings_popover.scss");
var _helpers = require("../../../shared_components/axis/extent/helpers");
var _axis_extent_settings = require("../../../shared_components/axis/extent/axis_extent_settings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const popoverConfig = (axis, isHorizontal) => {
  switch (axis) {
    case 'yLeft':
      return {
        icon: isHorizontal ? _chartIcons.EuiIconAxisBottom : _chartIcons.EuiIconAxisLeft,
        groupPosition: 'left',
        popoverTitle: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.bottomAxisLabel', {
          defaultMessage: 'Bottom axis'
        }) : _i18n.i18n.translate('xpack.lens.xyChart.leftAxisLabel', {
          defaultMessage: 'Left axis'
        }),
        buttonDataTestSubj: 'lnsLeftAxisButton'
      };
    case 'yRight':
      return {
        icon: isHorizontal ? _chartIcons.EuiIconAxisTop : _chartIcons.EuiIconAxisRight,
        groupPosition: 'right',
        popoverTitle: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.topAxisLabel', {
          defaultMessage: 'Top axis'
        }) : _i18n.i18n.translate('xpack.lens.xyChart.rightAxisLabel', {
          defaultMessage: 'Right axis'
        }),
        buttonDataTestSubj: 'lnsRightAxisButton'
      };
    case 'x':
    default:
      return {
        icon: isHorizontal ? _chartIcons.EuiIconAxisLeft : _chartIcons.EuiIconAxisBottom,
        groupPosition: 'center',
        popoverTitle: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.leftAxisLabel', {
          defaultMessage: 'Left axis'
        }) : _i18n.i18n.translate('xpack.lens.xyChart.bottomAxisLabel', {
          defaultMessage: 'Bottom axis'
        }),
        buttonDataTestSubj: 'lnsBottomAxisButton'
      };
  }
};
const axisOrientationOptions = [{
  id: 'xy_axis_orientation_horizontal',
  value: 0,
  label: _i18n.i18n.translate('xpack.lens.xyChart.axisOrientation.horizontal', {
    defaultMessage: 'Horizontal'
  })
}, {
  id: 'xy_axis_orientation_vertical',
  value: -90,
  label: _i18n.i18n.translate('xpack.lens.xyChart.axisOrientation.vertical', {
    defaultMessage: 'Vertical'
  })
}, {
  id: 'xy_axis_orientation_angled',
  value: -45,
  label: _i18n.i18n.translate('xpack.lens.xyChart.axisOrientation.angled', {
    defaultMessage: 'Angled'
  })
}];
const AxisSettingsPopover = ({
  layers,
  axis,
  axisTitle,
  updateTitleState,
  toggleTickLabelsVisibility,
  toggleGridlinesVisibility,
  isDisabled,
  areTickLabelsVisible,
  areGridlinesVisible,
  isTitleVisible,
  orientation,
  setOrientation,
  setEndzoneVisibility,
  endzonesVisible,
  setCurrentTimeMarkerVisibility,
  currentTimeMarkerVisible,
  extent,
  setExtent,
  hasBarOrAreaOnAxis,
  hasPercentageAxis,
  dataBounds,
  useMultilayerTimeAxis,
  scale,
  setScale,
  setScaleWithExtent
}) => {
  const isHorizontal = layers !== null && layers !== void 0 && layers.length ? (0, _state_helpers.isHorizontalChart)(layers) : false;
  const config = popoverConfig(axis, isHorizontal);
  const onExtentChange = (0, _react.useCallback)(newExtent => {
    if (setExtent && newExtent && !(0, _lodash.isEqual)(newExtent, extent)) {
      const {
        errorMsg
      } = (0, _helpers.validateExtent)(hasBarOrAreaOnAxis, newExtent, scale);
      if (axis === 'x' || newExtent.mode !== 'custom' || !errorMsg) {
        setExtent(newExtent);
      }
    }
  }, [setExtent, extent, hasBarOrAreaOnAxis, scale, axis]);
  const {
    inputValue: localExtent,
    handleInputChange: setLocalExtent
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: extent,
    onChange: onExtentChange
  });
  return /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: config.popoverTitle,
    type: config.icon,
    groupPosition: config.groupPosition,
    isDisabled: isDisabled,
    buttonDataTestSubj: config.buttonDataTestSubj,
    panelClassName: "lnsVisToolbarAxis__popover"
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarTitleSettings, {
    settingId: axis,
    title: axisTitle,
    updateTitleState: title => updateTitleState(title, axis),
    isTitleVisible: isTitleVisible
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.Gridlines', {
      defaultMessage: 'Gridlines'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": `lnsshow${axis}AxisGridlines`,
    label: _i18n.i18n.translate('xpack.lens.xyChart.Gridlines', {
      defaultMessage: 'Gridlines'
    }),
    onChange: () => toggleGridlinesVisibility(axis),
    checked: areGridlinesVisible,
    showLabel: false
  })), /*#__PURE__*/_react.default.createElement(_shared_components.AxisTicksSettings, {
    axis: axis,
    updateTicksVisibilityState: visible => {
      toggleTickLabelsVisibility(axis);
    },
    isAxisLabelVisible: areTickLabelsVisible
  }), !useMultilayerTimeAxis && areTickLabelsVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.axisOrientation.label', {
      defaultMessage: 'Orientation'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.axisOrientation.label', {
      defaultMessage: 'Orientation'
    }),
    "data-test-subj": "lnsXY_axisOrientation_groups",
    buttonSize: "compressed",
    options: axisOrientationOptions,
    idSelected: axisOrientationOptions.find(({
      value
    }) => value === orientation).id,
    onChange: optionId => {
      const newOrientation = axisOrientationOptions.find(({
        id
      }) => id === optionId).value;
      setOrientation(axis, newOrientation);
    }
  })), setEndzoneVisibility && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.showEnzones', {
      defaultMessage: 'Show partial data markers'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "lnsshowEndzones",
    label: _i18n.i18n.translate('xpack.lens.xyChart.showEnzones', {
      defaultMessage: 'Show partial data markers'
    }),
    onChange: () => setEndzoneVisibility(!Boolean(endzonesVisible)),
    checked: Boolean(endzonesVisible),
    showLabel: false
  })), setCurrentTimeMarkerVisibility && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.showCurrenTimeMarker', {
      defaultMessage: 'Show current time marker'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "lnsshowCurrentTimeMarker",
    label: _i18n.i18n.translate('xpack.lens.xyChart.showCurrenTimeMarker', {
      defaultMessage: 'Show current time marker'
    }),
    onChange: () => setCurrentTimeMarkerVisibility(!Boolean(currentTimeMarkerVisible)),
    checked: Boolean(currentTimeMarkerVisible),
    showLabel: false
  })), setScale && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.setScale', {
      defaultMessage: 'Axis scale'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    fullWidth: true,
    "data-test-subj": "lnsScaleSelect",
    "aria-label": _i18n.i18n.translate('xpack.lens.xyChart.setScale', {
      defaultMessage: 'Axis scale'
    }),
    options: [{
      text: _i18n.i18n.translate('xpack.lens.xyChart.scaleLinear', {
        defaultMessage: 'Linear'
      }),
      value: 'linear'
    }, {
      text: _i18n.i18n.translate('xpack.lens.xyChart.scaleLog', {
        defaultMessage: 'Logarithmic'
      }),
      value: 'log'
    }, {
      text: _i18n.i18n.translate('xpack.lens.xyChart.scaleSquare', {
        defaultMessage: 'Square root'
      }),
      value: 'sqrt'
    }],
    onChange: ({
      target
    }) => {
      if (!setScaleWithExtent || !extent) return;
      const newScale = target.value;
      setScaleWithExtent({
        ...extent,
        ...(0, _axis_extent_settings.getBounds)(extent.mode, newScale, dataBounds)
      }, newScale);
    },
    value: scale
  })), localExtent && setLocalExtent && /*#__PURE__*/_react.default.createElement(_shared_components.AxisBoundsControl, {
    type: axis !== 'x' ? 'metric' : 'bucket',
    extent: localExtent,
    scaleType: scale,
    setExtent: setLocalExtent,
    dataBounds: dataBounds,
    hasBarOrArea: hasBarOrAreaOnAxis,
    disableCustomRange: hasPercentageAxis,
    testSubjPrefix: "lnsXY"
    // X axis is passing the extent object only in case of numeric histogram
    ,
    canHaveNiceValues: axis !== 'x' || Boolean(extent)
  }));
};
exports.AxisSettingsPopover = AxisSettingsPopover;