"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAsyncHelpers = exports.CreateESQLPanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _public2 = require("@kbn/embeddable-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ACTION_CREATE_ESQL_CHART = 'ACTION_CREATE_ESQL_CHART';
const getAsyncHelpers = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
exports.getAsyncHelpers = getAsyncHelpers;
class CreateESQLPanelAction {
  constructor(startDependencies, core, getEditorFrameService) {
    (0, _defineProperty2.default)(this, "type", ACTION_CREATE_ESQL_CHART);
    (0, _defineProperty2.default)(this, "id", ACTION_CREATE_ESQL_CHART);
    (0, _defineProperty2.default)(this, "order", 50);
    (0, _defineProperty2.default)(this, "grouping", [_public2.ADD_PANEL_VISUALIZATION_GROUP]);
    this.startDependencies = startDependencies;
    this.core = core;
    this.getEditorFrameService = getEditorFrameService;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.lens.app.createVisualizationLabel', {
      defaultMessage: 'ES|QL'
    });
  }
  getIconType() {
    // need to create a new one
    return 'esqlVis';
  }
  async isCompatible({
    embeddable
  }) {
    if (!(0, _presentationContainers.apiIsPresentationContainer)(embeddable)) return false;
    const {
      isCreateActionCompatible
    } = await getAsyncHelpers();
    return isCreateActionCompatible(this.core);
  }
  async execute({
    embeddable
  }) {
    if (!(0, _presentationContainers.apiIsPresentationContainer)(embeddable)) throw new _public.IncompatibleActionError();
    const {
      executeCreateAction
    } = await getAsyncHelpers();
    const editorFrameService = await this.getEditorFrameService();
    executeCreateAction({
      deps: this.startDependencies,
      core: this.core,
      api: embeddable,
      editorFrameService
    });
  }
}
exports.CreateESQLPanelAction = CreateESQLPanelAction;