"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyPaletteParams = applyPaletteParams;
exports.findMinMaxByColumnId = void 0;
exports.getAccessorType = getAccessorType;
exports.getContrastColor = getContrastColor;
exports.getNumericValue = getNumericValue;
exports.getPaletteDisplayColors = getPaletteDisplayColors;
exports.shouldColorByTerms = shouldColorByTerms;
var _uiTheme = require("@kbn/ui-theme");
var _coloring = require("@kbn/coloring");
var _transposeUtils = require("@kbn/transpose-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns array of colors for provided palette or colorMapping
 */
function getPaletteDisplayColors(paletteService, palettes, isDarkMode, palette, colorMapping) {
  var _palette$params$stops, _palette$params, _palette$params$stops2, _palette$params2;
  return colorMapping ? (0, _coloring.getColorsFromMapping)(palettes, isDarkMode, colorMapping) : (palette === null || palette === void 0 ? void 0 : palette.name) === _coloring.CUSTOM_PALETTE ? (_palette$params$stops = palette === null || palette === void 0 ? void 0 : (_palette$params = palette.params) === null || _palette$params === void 0 ? void 0 : (_palette$params$stops2 = _palette$params.stops) === null || _palette$params$stops2 === void 0 ? void 0 : _palette$params$stops2.map(({
    color
  }) => color)) !== null && _palette$params$stops !== void 0 ? _palette$params$stops : [] : paletteService.get((palette === null || palette === void 0 ? void 0 : palette.name) || _coloring.DEFAULT_FALLBACK_PALETTE).getCategoricalColors((palette === null || palette === void 0 ? void 0 : (_palette$params2 = palette.params) === null || _palette$params2 === void 0 ? void 0 : _palette$params2.steps) || 10, palette);
}

/**
 * Analyze the column from the datasource prospective (formal check)
 * to know whether it's a numeric type or not
 * Note: to be used for Lens UI only
 */
function getAccessorType(datasource, accessor) {
  // No accessor means it's not a numeric type by default
  if (!accessor || !datasource) {
    return {
      isNumeric: false,
      isCategory: false
    };
  }
  const operation = datasource.getOperationForColumnId(accessor);
  const isNumericTypeFromOperation = Boolean(!(operation !== null && operation !== void 0 && operation.isBucketed) && (operation === null || operation === void 0 ? void 0 : operation.dataType) === 'number' && !operation.hasArraySupport);
  const isBucketableTypeFromOperationType = Boolean((operation === null || operation === void 0 ? void 0 : operation.isBucketed) || !['number', 'date'].includes((operation === null || operation === void 0 ? void 0 : operation.dataType) || '') && !(operation !== null && operation !== void 0 && operation.hasArraySupport));
  return {
    isNumeric: isNumericTypeFromOperation,
    isCategory: isBucketableTypeFromOperationType
  };
}

/**
 * Bucketed numerical columns should be treated as categorical
 * Note: to be used within expression renderer scope only
 */
function shouldColorByTerms(dataType, isBucketed) {
  return isBucketed || dataType !== 'number';
}
function getContrastColor(color, isDarkTheme, darkTextProp = 'euiColorInk', lightTextProp = 'euiColorGhost') {
  // when in light theme both text color and colorInk are dark and the choice
  // may depends on the specific context.
  const darkColor = isDarkTheme ? _uiTheme.euiDarkVars.euiColorInk : _uiTheme.euiLightVars[darkTextProp];
  // Same thing for light color in dark theme
  const lightColor = isDarkTheme ? _uiTheme.euiDarkVars[lightTextProp] : _uiTheme.euiLightVars.euiColorGhost;
  const backgroundColor = isDarkTheme ? _uiTheme.euiDarkVars.euiPageBackgroundColor : _uiTheme.euiLightVars.euiPageBackgroundColor;
  return (0, _coloring.enforceColorContrast)(color, backgroundColor) ? lightColor : darkColor;
}
function getNumericValue(rowValue) {
  return typeof rowValue === 'number' ? rowValue : undefined;
}
function applyPaletteParams(palettes, activePalette, dataBounds) {
  var _activePalette$params, _activePalette$params2;
  // make a copy of it as they have to be manipulated later on
  const displayStops = (0, _coloring.getPaletteStops)(palettes, (activePalette === null || activePalette === void 0 ? void 0 : activePalette.params) || {}, {
    dataBounds,
    defaultPaletteName: activePalette === null || activePalette === void 0 ? void 0 : activePalette.name
  });
  if (activePalette !== null && activePalette !== void 0 && (_activePalette$params = activePalette.params) !== null && _activePalette$params !== void 0 && _activePalette$params.reverse && (activePalette === null || activePalette === void 0 ? void 0 : (_activePalette$params2 = activePalette.params) === null || _activePalette$params2 === void 0 ? void 0 : _activePalette$params2.name) !== _coloring.CUSTOM_PALETTE) {
    return (0, _coloring.reversePalette)(displayStops);
  }
  return displayStops;
}
const findMinMaxByColumnId = (columnIds, table) => {
  const minMaxMap = new Map();
  if (table != null) {
    for (const columnId of columnIds) {
      var _minMaxMap$get;
      const originalId = (0, _transposeUtils.getOriginalId)(columnId);
      const minMax = (_minMaxMap$get = minMaxMap.get(originalId)) !== null && _minMaxMap$get !== void 0 ? _minMaxMap$get : {
        max: Number.NEGATIVE_INFINITY,
        min: Number.POSITIVE_INFINITY
      };
      table.rows.forEach(row => {
        const rowValue = row[columnId];
        const numericValue = getNumericValue(rowValue);
        if (numericValue != null) {
          if (minMax.min > numericValue) {
            minMax.min = numericValue;
          }
          if (minMax.max < numericValue) {
            minMax.max = numericValue;
          }
        }
      });

      // what happens when there's no data in the table? Fallback to a percent range
      if (minMax.max === Number.NEGATIVE_INFINITY) {
        minMaxMap.set(originalId, (0, _coloring.getFallbackDataBounds)());
      } else {
        minMaxMap.set(originalId, minMax);
      }
    }
  }
  return minMaxMap;
};
exports.findMinMaxByColumnId = findMinMaxByColumnId;