"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorMappingByTerms = ColorMappingByTerms;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _i18n = require("@kbn/i18n");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _palette_picker = require("../palette_picker");
var _palette_panel_container = require("./palette_panel_container");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ColorMappingByTerms({
  isDarkMode,
  colorMapping,
  palette,
  palettes,
  isInlineEditing,
  setPalette,
  setColorMapping,
  paletteService,
  panelRef,
  categories
}) {
  const [useNewColorMapping, setUseNewColorMapping] = (0, _react.useState)(Boolean(colorMapping));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingSectionLabel', {
      defaultMessage: 'Color mapping'
    }),
    style: {
      alignItems: 'center'
    },
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_palette_panel_container.PalettePanelContainer, {
    palette: (0, _utils.getPaletteDisplayColors)(paletteService, palettes, isDarkMode, palette, colorMapping),
    siblingRef: panelRef,
    title: useNewColorMapping ? _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingTitle', {
      defaultMessage: 'Assign colors to terms'
    }) : _i18n.i18n.translate('xpack.lens.colorMapping.editColorsTitle', {
      defaultMessage: 'Edit colors'
    }),
    isInlineEditing: isInlineEditing
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "lns-palettePanel-terms",
    className: "lnsPalettePanel__section lnsPalettePanel__section--shaded lnsIndexPatternDimensionEditor--padded"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.lens.colorMapping.tryLabel', {
      defaultMessage: 'Use the new Color Mapping feature'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.lens.colorMapping.techPreviewLabel', {
      defaultMessage: 'Tech preview'
    })))),
    "data-test-subj": "lns_colorMappingOrLegacyPalette_switch",
    compressed: true,
    checked: useNewColorMapping,
    onChange: ({
      target: {
        checked
      }
    }) => {
      (0, _lens_ui_telemetry.trackUiCounterEvents)(`color_mapping_switch_${checked ? 'enabled' : 'disabled'}`);
      setColorMapping(checked ? {
        ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
      } : undefined);
      setUseNewColorMapping(checked);
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, useNewColorMapping ? /*#__PURE__*/_react.default.createElement(_coloring.CategoricalColorMapping, {
    isDarkMode: isDarkMode,
    model: colorMapping !== null && colorMapping !== void 0 ? colorMapping : {
      ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
    },
    onModelUpdate: setColorMapping,
    specialTokens: _coloring.SPECIAL_TOKENS_STRING_CONVERSION,
    palettes: palettes,
    data: {
      type: 'categories',
      categories
    }
  }) : /*#__PURE__*/_react.default.createElement(_palette_picker.PalettePicker, {
    palettes: paletteService,
    activePalette: palette,
    setPalette: setPalette
  }))))));
}