"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeToStorage = exports.readFromStorage = exports.LOCAL_STORAGE_LENS_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_LENS_KEY = exports.LOCAL_STORAGE_LENS_KEY = 'lens-settings';
const readFromStorage = (storage, key) => {
  const data = storage.get(LOCAL_STORAGE_LENS_KEY);
  return data && data[key];
};
exports.readFromStorage = readFromStorage;
const writeToStorage = (storage, key, value) => {
  storage.set(LOCAL_STORAGE_LENS_KEY, {
    ...storage.get(LOCAL_STORAGE_LENS_KEY),
    [key]: value
  });
};
exports.writeToStorage = writeToStorage;