"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserMessages = UserMessages;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _error_panel = require("./error_panel");
var _info_badges = require("./info_badges");
var _message_popover = require("./message_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function UserMessages({
  blockingErrors,
  warningOrErrors,
  infoMessages,
  canEdit
}) {
  if (!blockingErrors.length && !warningOrErrors.length && !infoMessages.length) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_error_panel.VisualizationErrorPanel, {
    errors: blockingErrors,
    canEdit: canEdit
  }), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)({
      position: 'absolute',
      zIndex: 2,
      left: 0,
      bottom: 0
    })
  }, /*#__PURE__*/_react2.default.createElement(_message_popover.MessagesPopover, {
    messages: warningOrErrors
  }), /*#__PURE__*/_react2.default.createElement(_info_badges.EmbeddableFeatureBadge, {
    messages: infoMessages
  })));
}