"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareInlineEditPanel = prepareInlineEditPanel;
var _public = require("@kbn/embeddable-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _utils = require("../../utils");
var _helper = require("../helper");
var _state_management = require("./state_management");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function prepareInlineEditPanel(initialState, getState, updateState, {
  dataLoading$,
  isNewlyCreated$
}, panelManagementApi, inspectorApi, {
  coreStart,
  ...startDependencies
}, navigateToLensEditor, uuid, parentApi) {
  return async function openConfigPanel({
    onApply,
    onCancel,
    hideTimeFilterInfo
  } = {}) {
    const {
      getEditLensConfiguration,
      getVisualizationMap,
      getDatasourceMap
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
    const visualizationMap = getVisualizationMap();
    const datasourceMap = getDatasourceMap();
    const currentState = getState();
    const attributes = currentState.attributes;
    const activeDatasourceId = (0, _utils.getActiveDatasourceIdFromDoc)(attributes) || 'formBased';
    const {
      updatePanelState,
      updateSuggestion
    } = (0, _state_management.getStateManagementForInlineEditing)(activeDatasourceId, () => getState().attributes, (attrs, resetId = false) => {
      updateState({
        attributes: attrs,
        savedObjectId: resetId ? undefined : currentState.savedObjectId
      });
    }, visualizationMap, datasourceMap, startDependencies.data.query.filterManager.extract);
    const updateByRefInput = savedObjectId => {
      updateState({
        attributes,
        savedObjectId
      });
    };
    const Component = await getEditLensConfiguration(coreStart, startDependencies, visualizationMap, datasourceMap);
    if ((attributes === null || attributes === void 0 ? void 0 : attributes.visualizationType) == null) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(Component, {
      attributes: attributes,
      updateByRefInput: updateByRefInput,
      updatePanelState: updatePanelState,
      updateSuggestion: updateSuggestion,
      datasourceId: activeDatasourceId,
      lensAdapters: inspectorApi.getInspectorAdapters(),
      dataLoading$: dataLoading$,
      panelId: uuid,
      savedObjectId: currentState.savedObjectId,
      navigateToLensEditor: !(0, _helper.isTextBasedLanguage)(currentState) && navigateToLensEditor ? navigateToLensEditor(new _public.EmbeddableStateTransfer(coreStart.application.navigateToApp, coreStart.application.currentAppId$), true) : undefined,
      displayFlyoutHeader: true,
      canEditTextBasedQuery: (0, _helper.isTextBasedLanguage)(currentState),
      isNewPanel: panelManagementApi.isNewPanel(),
      onCancel: () => {
        panelManagementApi.onStopEditing(true,
        // DSL/form based charts are created via the full editor, so there's
        // an initial state to preserve. ES|QL charts are created inline, so it needs to pass an empty state
        // and the panelManagementApi will decide whether to remove the panel or not
        isNewlyCreated$.getValue() ? undefined : initialState);
        onCancel === null || onCancel === void 0 ? void 0 : onCancel();
      },
      onApply: newAttributes => {
        panelManagementApi.onStopEditing(false, {
          ...getState(),
          attributes: newAttributes
        });
        if (newAttributes.visualizationType != null) {
          onApply === null || onApply === void 0 ? void 0 : onApply(newAttributes);
        }
      },
      hideTimeFilterInfo: hideTimeFilterInfo,
      parentApi: parentApi
    });
  };
}