"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountInlineEditPanel = mountInlineEditPanel;
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shared logic to mount the inline config panel
 * @param ConfigPanel
 * @param coreStart
 * @param overlayTracker
 * @param uuid
 * @param container
 */
function mountInlineEditPanel(ConfigPanel, coreStart, overlayTracker, uuid, container) {
  if (container) {
    _reactDom.default.render(ConfigPanel, container);
  } else {
    const handle = coreStart.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.cloneElement(ConfigPanel, {
      closeFlyout: () => {
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        handle.close();
      }
    }), coreStart), {
      className: 'lnsConfigPanel__overlay',
      size: 's',
      'data-test-subj': 'customizeLens',
      type: 'push',
      paddingSize: 'm',
      maxWidth: 800,
      hideCloseButton: true,
      isResizable: true,
      onClose: overlayRef => {
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        overlayRef.close();
      },
      outsideClickCloses: true
    });
    if (uuid) {
      overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(handle, {
        focusedPanelId: uuid
      });
    }
  }
}