"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSearchContext = initializeSearchContext;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _publishes_search_session = require("@kbn/presentation-publishing/interfaces/fetch/publishes_search_session");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _helper = require("../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeSearchContext(initialState, internalApi, parentApi, {
  injectFilterReferences
}) {
  const [searchSessionId$] = (0, _helper.buildObservableVariable)((0, _publishes_search_session.apiPublishesSearchSession)(parentApi) ? parentApi.searchSessionId$ : undefined);
  const attributes = internalApi.attributes$.getValue();
  const [lastReloadRequestTime] = (0, _helper.buildObservableVariable)(undefined);

  // Make sure the panel access the filters with the correct references
  const [filters$] = (0, _helper.buildObservableVariable)(injectFilterReferences(attributes.state.filters, attributes.references));
  const [query$] = (0, _helper.buildObservableVariable)(attributes.state.query);
  const [timeslice$] = (0, _helper.buildObservableVariable)(undefined);
  const timeRange = (0, _presentationPublishing.initializeTimeRange)(initialState);
  const subscriptions = [internalApi.attributes$.pipe((0, _rxjs.map)(attrs => attrs.state.query), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(query$), internalApi.attributes$.pipe((0, _rxjs.map)(attrs => attrs.state.filters), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(filters$)];
  return {
    api: {
      searchSessionId$,
      filters$,
      query$,
      timeslice$,
      isCompatibleWithUnifiedSearch: () => true,
      ...timeRange.api
    },
    comparators: {
      query: (0, _presentationPublishing.getUnchangingComparator)(),
      filters: (0, _presentationPublishing.getUnchangingComparator)(),
      timeslice: (0, _presentationPublishing.getUnchangingComparator)(),
      searchSessionId: (0, _presentationPublishing.getUnchangingComparator)(),
      lastReloadRequestTime: (0, _presentationPublishing.getUnchangingComparator)(),
      ...timeRange.comparators
    },
    cleanup: () => {
      subscriptions.forEach(sub => sub.unsubscribe());
    },
    serialize: () => ({
      searchSessionId: searchSessionId$.getValue(),
      filters: filters$.getValue(),
      query: query$.getValue(),
      timeslice: timeslice$.getValue(),
      lastReloadRequestTime: lastReloadRequestTime.getValue(),
      ...timeRange.serialize()
    })
  };
}