"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeInspector = initializeInspector;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _lens_inspector_service = require("../../lens_inspector_service");
var _helper = require("../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeInspector(services) {
  const inspectorApi = (0, _lens_inspector_service.getLensInspectorService)(services.inspector);
  return {
    api: {
      ...inspectorApi,
      adapters$: new _rxjs.BehaviorSubject(inspectorApi.getInspectorAdapters())
    },
    comparators: {},
    serialize: _helper.emptySerializer,
    cleanup: _lodash.noop
  };
}