"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableDimensionButton = DraggableDimensionButton;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _utils = require("../../../../utils");
var _types = require("../../../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DraggableDimensionButton({
  order,
  group,
  onDrop,
  activeVisualization,
  onDragStart,
  onDragEnd,
  children,
  state,
  layerDatasource,
  datasourceLayers,
  registerNewButtonRef,
  indexPatterns,
  target
}) {
  var _getDropProps;
  const [{
    dragging
  }] = (0, _domDragDrop.useDragDropContext)();
  let getDropProps;
  if (dragging) {
    var _datasourceLayers$dra, _datasourceLayers$tar;
    if (!layerDatasource) {
      getDropProps = activeVisualization.getDropProps;
    } else if ((0, _utils.isDraggedField)(dragging) || (0, _types.isOperation)(dragging) && layerDatasource && (datasourceLayers === null || datasourceLayers === void 0 ? void 0 : (_datasourceLayers$dra = datasourceLayers[dragging.layerId]) === null || _datasourceLayers$dra === void 0 ? void 0 : _datasourceLayers$dra.datasourceId) === (datasourceLayers === null || datasourceLayers === void 0 ? void 0 : (_datasourceLayers$tar = datasourceLayers[target.layerId]) === null || _datasourceLayers$tar === void 0 ? void 0 : _datasourceLayers$tar.datasourceId)) {
      getDropProps = layerDatasource.getDropProps;
    }
  }
  const {
    dropTypes,
    nextLabel
  } = ((_getDropProps = getDropProps) === null || _getDropProps === void 0 ? void 0 : _getDropProps({
    state,
    source: dragging,
    target,
    indexPatterns
  })) || {
    dropTypes: [],
    nextLabel: ''
  };
  const canDuplicate = !!(dropTypes.includes('replace_duplicate_incompatible') || dropTypes.includes('replace_duplicate_compatible'));
  const canSwap = !!(dropTypes.includes('swap_incompatible') || dropTypes.includes('swap_compatible'));
  const canCombine = Boolean(dropTypes.includes('combine_compatible') || dropTypes.includes('field_combine') || dropTypes.includes('combine_incompatible'));
  const value = (0, _react.useMemo)(() => ({
    ...target,
    humanData: {
      ...target.humanData,
      canSwap,
      canDuplicate,
      canCombine,
      nextLabel: nextLabel || ''
    }
  }), [target, nextLabel, canDuplicate, canSwap, canCombine]);
  const reorderableGroup = (0, _react.useMemo)(() => group.accessors.map(g => ({
    id: g.columnId
  })), [group.accessors]);
  const registerNewButtonRefMemoized = (0, _react.useCallback)(el => registerNewButtonRef(target.columnId, el), [registerNewButtonRef, target.columnId]);
  const handleOnDrop = (0, _react.useCallback)((source, selectedDropType) => onDrop(source, value, selectedDropType), [value, onDrop]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: registerNewButtonRefMemoized,
    className: "lnsLayerPanel__dimensionContainer",
    "data-test-subj": group.dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.Draggable, {
    dragType: (0, _types.isOperation)(dragging) ? 'move' : 'copy',
    order: order,
    reorderableGroup: reorderableGroup.length > 1 ? reorderableGroup : undefined,
    value: value,
    onDragStart: onDragStart,
    onDragEnd: onDragEnd
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.Droppable, {
    dropTypes: dropTypes,
    getCustomDropTarget: _domDragDrop.DropTargetSwapDuplicateCombine.getCustomDropTarget,
    getAdditionalClassesOnEnter: _domDragDrop.DropTargetSwapDuplicateCombine.getAdditionalClassesOnEnter,
    getAdditionalClassesOnDroppable: _domDragDrop.DropTargetSwapDuplicateCombine.getAdditionalClassesOnDroppable,
    order: order,
    reorderableGroup: reorderableGroup.length > 1 ? reorderableGroup : undefined,
    value: value,
    onDrop: handleOnDrop
  }, children)));
}