"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpression = toExpression;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getExpressionForLayer(layer, layerId, refs) {
  var _layer$columns, _layer$timeField;
  if (!layer.columns || ((_layer$columns = layer.columns) === null || _layer$columns === void 0 ? void 0 : _layer$columns.length) === 0) {
    return null;
  }
  let idMapper = {};
  layer.columns.forEach(col => {
    if (idMapper[col.fieldName]) {
      idMapper[col.fieldName].push({
        id: col.columnId,
        label: col.customLabel ? col.label : col.fieldName,
        variable: col === null || col === void 0 ? void 0 : col.variable
      });
    } else {
      idMapper = {
        ...idMapper,
        [col.fieldName]: [{
          id: col.columnId,
          label: col.customLabel ? col.label : col.fieldName,
          variable: col === null || col === void 0 ? void 0 : col.variable
        }]
      };
    }
  });
  const timeFieldName = (_layer$timeField = layer.timeField) !== null && _layer$timeField !== void 0 ? _layer$timeField : undefined;
  const formatterOverrides = layer.columns.filter(col => {
    var _col$params;
    return (_col$params = col.params) === null || _col$params === void 0 ? void 0 : _col$params.format;
  }).map(col => {
    var _format$params;
    const format = col.params.format;
    const base = {
      type: 'function',
      function: 'lens_format_column',
      arguments: {
        format: format ? [format.id] : [''],
        columnId: [col.columnId],
        decimals: typeof (format === null || format === void 0 ? void 0 : (_format$params = format.params) === null || _format$params === void 0 ? void 0 : _format$params.decimals) === 'number' ? [format.params.decimals] : [],
        suffix: format !== null && format !== void 0 && format.params && 'suffix' in format.params && format.params.suffix ? [format.params.suffix] : [],
        compact: format !== null && format !== void 0 && format.params && 'compact' in format.params && format.params.compact ? [format.params.compact] : [],
        pattern: format !== null && format !== void 0 && format.params && 'pattern' in format.params && format.params.pattern ? [format.params.pattern] : [],
        fromUnit: format !== null && format !== void 0 && format.params && 'fromUnit' in format.params && format.params.fromUnit ? [format.params.fromUnit] : [],
        toUnit: format !== null && format !== void 0 && format.params && 'toUnit' in format.params && format.params.toUnit ? [format.params.toUnit] : [],
        parentFormat: []
      }
    };
    return base;
  });
  if (!layer.table) {
    const textBasedQueryToAst = (0, _common.textBasedQueryStateToExpressionAst)({
      query: layer.query,
      timeFieldName,
      titleForInspector: _i18n.i18n.translate('xpack.lens.inspectorTextBasedRequestDataTitle', {
        defaultMessage: 'Visualization'
      }),
      descriptionForInspector: _i18n.i18n.translate('xpack.lens.inspectorTextBasedRequestDescription', {
        defaultMessage: 'This request queries Elasticsearch to fetch the data for the visualization.'
      })
    });
    textBasedQueryToAst.chain.push({
      type: 'function',
      function: 'lens_map_to_columns',
      arguments: {
        idMap: [JSON.stringify(idMapper)],
        isTextBased: [true]
      }
    });
    textBasedQueryToAst.chain.push(...formatterOverrides);
    return textBasedQueryToAst;
  } else {
    return {
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'var',
        arguments: {
          name: [layerId]
        }
      }, {
        type: 'function',
        function: 'lens_map_to_columns',
        arguments: {
          idMap: [JSON.stringify(idMapper)]
        }
      }, ...formatterOverrides]
    };
  }
}
function toExpression(state, layerId) {
  if (state.layers[layerId]) {
    return getExpressionForLayer(state.layers[layerId], layerId, state.indexPatternRefs);
  }
  return null;
}