"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDisallowedTermsMessage = getDisallowedTermsMessage;
exports.getFieldsByValidationState = getFieldsByValidationState;
exports.getMultiTermsScriptedFieldErrorMessage = getMultiTermsScriptedFieldErrorMessage;
exports.getOtherBucketSwitchDefault = getOtherBucketSwitchDefault;
exports.isPercentileRankSortable = isPercentileRankSortable;
exports.isPercentileSortable = isPercentileSortable;
exports.isRuntimeField = isRuntimeField;
exports.isScriptedField = isScriptedField;
exports.isSortableByColumn = isSortableByColumn;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _field_stats = require("@kbn/unified-field-list/src/services/field_stats");
var _ = require("..");
var _filters = require("../filters");
var _layer_helpers = require("../../layer_helpers");
var _constants = require("./constants");
var _helpers = require("../helpers");
var _user_messages_ids = require("../../../../../user_messages_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullSeparatorString = ` ${_constants.MULTI_KEY_VISUAL_SEPARATOR} `;
function getMultiTermsScriptedFieldErrorMessage(layer, columnId, indexPattern) {
  var _currentColumn$params;
  const currentColumn = layer.columns[columnId];
  const usedFields = [currentColumn.sourceField, ...((_currentColumn$params = currentColumn.params.secondaryFields) !== null && _currentColumn$params !== void 0 ? _currentColumn$params : [])];
  const scriptedFields = usedFields.filter(field => {
    var _indexPattern$getFiel;
    return (_indexPattern$getFiel = indexPattern.getFieldByName(field)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.scripted;
  });
  if (usedFields.length < 2 || !scriptedFields.length) {
    return [];
  }
  return [{
    uniqueId: _user_messages_ids.TERMS_MULTI_TERMS_AND_SCRIPTED_FIELDS,
    message: _i18n.i18n.translate('xpack.lens.indexPattern.termsWithMultipleTermsAndScriptedFields', {
      defaultMessage: 'Scripted fields are not supported when using multiple fields, found {fields}',
      values: {
        fields: scriptedFields.join(', ')
      }
    })
  }];
}
function getQueryForMultiTerms(fieldNames, term) {
  const terms = term.split(fullSeparatorString);
  return fieldNames.map((fieldName, i) => `${fieldName}: ${terms[i] !== '*' ? `"${terms[i]}"` : terms[i]}`).join(' AND ');
}
function getQueryLabel(fieldNames, term) {
  if (fieldNames.length === 1) {
    return term;
  }
  return term.split(fullSeparatorString).map((t, index) => {
    if (t == null) {
      return _i18n.i18n.translate('xpack.lens.indexPattern.filterBy.emptyFilterQuery', {
        defaultMessage: '(empty)'
      });
    }
    return `${fieldNames[index]}: ${t}`;
  }).join(fullSeparatorString);
}
function isMultiFieldValue(term) {
  return typeof term === 'object' && term != null && 'keys' in term && Array.isArray(term.keys);
}
function getDisallowedTermsMessage(layer, columnId, indexPattern) {
  const referenced = new Set();
  Object.entries(layer.columns).forEach(([cId, c]) => {
    if ('references' in c) {
      c.references.forEach(r => {
        referenced.add(r);
      });
    }
  });
  const hasMultipleShifts = (0, _lodash.uniq)(Object.entries(layer.columns).filter(([colId, col]) => _.operationDefinitionMap[col.operationType].shiftable && (!(0, _layer_helpers.isReferenced)(layer, colId) || col.timeShift)).map(([colId, col]) => col.timeShift || '')).length > 1;
  if (!hasMultipleShifts) {
    return [];
  }
  return [{
    uniqueId: _user_messages_ids.TERMS_WITH_MULTIPLE_TIMESHIFT,
    message: _i18n.i18n.translate('xpack.lens.indexPattern.termsWithMultipleShifts', {
      defaultMessage: 'In a single layer, you are unable to combine metrics with different time shifts and dynamic top values. Use the same time shift value for all metrics, or use filters instead of top values.'
    }),
    fixAction: {
      label: _i18n.i18n.translate('xpack.lens.indexPattern.termsWithMultipleShiftsFixActionLabel', {
        defaultMessage: 'Use filters'
      }),
      newState: async (data, core, frame, layerId) => {
        var _currentColumn$params2, _currentColumn$params3, _frame$activeData, _frame$activeData$lay, _frame$activeData2;
        const currentColumn = layer.columns[columnId];
        const fieldNames = [currentColumn.sourceField, ...((_currentColumn$params2 = (_currentColumn$params3 = currentColumn.params) === null || _currentColumn$params3 === void 0 ? void 0 : _currentColumn$params3.secondaryFields) !== null && _currentColumn$params2 !== void 0 ? _currentColumn$params2 : [])];
        const activeDataFieldNameMatch = ((_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : (_frame$activeData$lay = _frame$activeData[layerId].columns.find(({
          id
        }) => id === columnId)) === null || _frame$activeData$lay === void 0 ? void 0 : _frame$activeData$lay.meta.field) === fieldNames[0];
        let currentTerms = (0, _lodash.uniq)(((_frame$activeData2 = frame.activeData) === null || _frame$activeData2 === void 0 ? void 0 : _frame$activeData2[layerId].rows.map(row => row[columnId]).filter(term => fieldNames.length > 1 ? isMultiFieldValue(term) && term.keys[0] !== '__other__' : typeof term === 'string' && term !== '__other__').map(term => isMultiFieldValue(term) ? term.keys.join(fullSeparatorString) : term)) || []);
        if (!activeDataFieldNameMatch || currentTerms.length === 0) {
          if (fieldNames.length === 1) {
            var _response$topValues;
            const currentDataView = await data.dataViews.get(indexPattern.id);
            const response = await (0, _field_stats.loadFieldStats)({
              services: {
                data
              },
              dataView: currentDataView,
              field: indexPattern.getFieldByName(fieldNames[0]),
              dslQuery: (0, _esQuery.buildEsQuery)(indexPattern, frame.query, frame.filters, (0, _public.getEsQueryConfig)(core.uiSettings)),
              fromDate: frame.dateRange.fromDate,
              toDate: frame.dateRange.toDate,
              size: currentColumn.params.size
            });
            currentTerms = ((_response$topValues = response.topValues) === null || _response$topValues === void 0 ? void 0 : _response$topValues.buckets.map(({
              key
            }) => String(key))) || [];
          }
        }
        // when multi terms the meta.field will always be undefined, so limit the check to no data
        if (fieldNames.length > 1 && currentTerms.length === 0) {
          // this will produce a query like `field1: * AND field2: * ...etc`
          // which is the best we can do for multiple terms when no data is available
          currentTerms = [Array(fieldNames.length).fill('*').join(fullSeparatorString)];
        }
        return {
          ...layer,
          columns: {
            ...layer.columns,
            [columnId]: {
              label: _i18n.i18n.translate('xpack.lens.indexPattern.pinnedTopValuesLabel', {
                defaultMessage: 'Filters of {field}',
                values: {
                  field: fieldNames.length > 1 ? fieldNames.join(fullSeparatorString) : fieldNames[0]
                }
              }),
              customLabel: true,
              isBucketed: layer.columns[columnId].isBucketed,
              dataType: 'string',
              operationType: 'filters',
              params: {
                filters: currentTerms.length > 0 ? currentTerms.map(term => ({
                  input: {
                    query: fieldNames.length === 1 ? `${fieldNames[0]}: "${term}"` : getQueryForMultiTerms(fieldNames, term),
                    language: 'kuery'
                  },
                  label: getQueryLabel(fieldNames, term)
                })) : [{
                  input: {
                    query: '*',
                    language: 'kuery'
                  },
                  label: _filters.defaultLabel
                }]
              }
            }
          }
        };
      }
    }
  }];
}
function checkLastValue(column) {
  return column.operationType !== 'last_value' || ['number', 'date'].includes(column.dataType) && !column.params.showArrayValues;
}

// allow the rank by metric only if the percentile rank value is integer
// https://github.com/elastic/elasticsearch/issues/66677

function isPercentileSortable(column) {
  const isPercentileColumn = (0, _helpers.isColumnOfType)('percentile', column);
  return !isPercentileColumn || isPercentileColumn && Number.isInteger(column.params.percentile);
}
function isPercentileRankSortable(column) {
  const isPercentileRankColumn = (0, _helpers.isColumnOfType)('percentile_rank', column);
  return !isPercentileRankColumn || isPercentileRankColumn && Number.isInteger(column.params.value);
}
function isSortableByColumn(layer, columnId) {
  const column = layer.columns[columnId];
  return column && !column.isBucketed && checkLastValue(column) && isPercentileRankSortable(column) && isPercentileSortable(column) && !('references' in column) && !(0, _layer_helpers.isReferenced)(layer, columnId);
}
function isScriptedField(fieldName, indexPattern) {
  if (typeof fieldName === 'string') {
    const field = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getFieldByName(fieldName);
    return field && field.scripted;
  }
  return fieldName.scripted;
}
function isRuntimeField(field) {
  return Boolean(field.runtime);
}
function getFieldsByValidationState(newIndexPattern, column, field) {
  const newFieldNames = [];
  if (column && 'sourceField' in column) {
    if (column.sourceField) {
      newFieldNames.push(column.sourceField);
    }
    if ((0, _helpers.isColumnOfType)('terms', column)) {
      var _column$params$second, _column$params;
      newFieldNames.push(...((_column$params$second = (_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.secondaryFields) !== null && _column$params$second !== void 0 ? _column$params$second : []));
    }
  }
  if (field) {
    newFieldNames.push(typeof field === 'string' ? field : field.name || field.displayName);
  }
  const newFields = newFieldNames.map(fieldName => newIndexPattern.getFieldByName(fieldName));
  // lodash groupby does not provide the index arg, so had to write it manually :(
  const validFields = [];
  const invalidFields = [];
  // mind to check whether a column was passed, in such case single term with scripted field is ok
  const canAcceptScripted = Boolean(column && newFields.length === 1);
  newFieldNames.forEach((fieldName, i) => {
    const newField = newFields[i];
    const isValid = newField && _constants.supportedTypes.has(newField.type) && newField.aggregatable && newField.timeSeriesMetric !== 'counter' && (!newField.aggregationRestrictions || newField.aggregationRestrictions.terms) && (canAcceptScripted || !isScriptedField(newField));
    const arrayToPush = isValid ? validFields : invalidFields;
    arrayToPush.push(fieldName);
  });
  return {
    allFields: newFields,
    validFields,
    invalidFields
  };
}
function getOtherBucketSwitchDefault(column, size) {
  const otherBucketValue = column.params.otherBucket;
  return (otherBucketValue || otherBucketValue === undefined) && size < _constants.MAX_TERMS_OTHER_ENABLED;
}