"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overallSumOperation = exports.overallMinOperation = exports.overallMaxOperation = exports.overallAverageOperation = void 0;
var _i18n = require("@kbn/i18n");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _utils = require("./utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildOverallMetricOperation({
  type,
  displayName,
  ofName,
  metric
}) {
  return {
    type,
    priority: 1,
    displayName,
    input: 'fullReference',
    selectionStyle: 'hidden',
    requiredReferences: [{
      input: ['field', 'managedReference', 'fullReference'],
      validateMetadata: meta => meta.dataType === 'number' && !meta.isBucketed
    }],
    getPossibleOperation: () => {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    },
    getDefaultLabel: (column, columns, indexPattern) => {
      var _indexPattern$getFiel;
      const ref = columns[column.references[0]];
      return ofName(ref && 'sourceField' in ref ? indexPattern === null || indexPattern === void 0 ? void 0 : (_indexPattern$getFiel = indexPattern.getFieldByName(ref.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.displayName : undefined);
    },
    toExpression: (layer, columnId) => {
      return (0, _utils.optionalHistogramBasedOperationToExpression)(layer, columnId, 'overall_metric', {
        metric: [metric]
      });
    },
    buildColumn: ({
      referenceIds,
      previousColumn,
      layer,
      indexPattern
    }, columnParams) => {
      var _indexPattern$getFiel2;
      const ref = layer.columns[referenceIds[0]];
      return {
        label: ofName(ref && 'sourceField' in ref ? (_indexPattern$getFiel2 = indexPattern.getFieldByName(ref.sourceField)) === null || _indexPattern$getFiel2 === void 0 ? void 0 : _indexPattern$getFiel2.displayName : undefined),
        dataType: 'number',
        operationType: `overall_${metric}`,
        isBucketed: false,
        scale: 'ratio',
        references: referenceIds,
        params: (0, _helpers.getFormatFromPreviousColumn)(previousColumn)
      };
    },
    isTransferable: () => {
      return true;
    },
    filterable: false,
    shiftable: false
  };
}
const overallSumOperation = exports.overallSumOperation = buildOverallMetricOperation({
  type: _lensFormulaDocs.OVERALL_SUM_ID,
  displayName: _lensFormulaDocs.OVERALL_SUM_NAME,
  ofName: name => {
    return _i18n.i18n.translate('xpack.lens.indexPattern.overallSumOf', {
      defaultMessage: 'Overall sum of {name}',
      values: {
        name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
          defaultMessage: '(incomplete)'
        })
      }
    });
  },
  metric: _lensFormulaDocs.SUM_ID
});
const overallMinOperation = exports.overallMinOperation = buildOverallMetricOperation({
  type: _lensFormulaDocs.OVERALL_MIN_ID,
  displayName: _lensFormulaDocs.OVERALL_MIN_NAME,
  ofName: name => {
    return _i18n.i18n.translate('xpack.lens.indexPattern.overallMinOf', {
      defaultMessage: 'Overall min of {name}',
      values: {
        name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
          defaultMessage: '(incomplete)'
        })
      }
    });
  },
  metric: _lensFormulaDocs.MIN_ID
});
const overallMaxOperation = exports.overallMaxOperation = buildOverallMetricOperation({
  type: _lensFormulaDocs.OVERALL_MAX_ID,
  displayName: _lensFormulaDocs.OVERALL_MAX_NAME,
  ofName: name => {
    return _i18n.i18n.translate('xpack.lens.indexPattern.overallMaxOf', {
      defaultMessage: 'Overall max of {name}',
      values: {
        name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
          defaultMessage: '(incomplete)'
        })
      }
    });
  },
  metric: _lensFormulaDocs.MAX_ID
});
const overallAverageOperation = exports.overallAverageOperation = buildOverallMetricOperation({
  type: _lensFormulaDocs.OVERALL_AVERAGE_ID,
  displayName: _lensFormulaDocs.OVERALL_AVERAGE_NAME,
  ofName: name => {
    return _i18n.i18n.translate('xpack.lens.indexPattern.overallAverageOf', {
      defaultMessage: 'Overall average of {name}',
      values: {
        name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
          defaultMessage: '(incomplete)'
        })
      }
    });
  },
  metric: _lensFormulaDocs.AVG_ID
});