"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.counterRateOperation = void 0;
var _i18n = require("@kbn/i18n");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _utils = require("./utils");
var _time_scale_utils = require("../../time_scale_utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ofName = (0, _utils.buildLabelFunction)(name => {
  return _i18n.i18n.translate('xpack.lens.indexPattern.CounterRateOf', {
    defaultMessage: 'Counter rate of {name}',
    values: {
      name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
        defaultMessage: '(incomplete)'
      })
    }
  });
});
const counterRateOperation = exports.counterRateOperation = {
  type: _lensFormulaDocs.COUNTER_RATE_ID,
  priority: 1,
  displayName: _lensFormulaDocs.COUNTER_RATE_NAME,
  input: 'fullReference',
  selectionStyle: 'field',
  requiredReferences: [{
    input: ['field', 'managedReference'],
    specificOperations: ['max'],
    validateMetadata: meta => meta.dataType === 'number' && !meta.isBucketed
  }],
  // return false for quick function as the built-in reference will use max
  // in formula this check won't be used and the check is performed on the formula AST tree traversal independently
  getUnsupportedSettings: () => ({
    sampling: false
  }),
  getPossibleOperation: indexPattern => {
    if ((0, _utils.hasDateField)(indexPattern)) {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    }
  },
  getDefaultLabel: (column, columns, indexPattern) => {
    var _indexPattern$getFiel;
    const ref = columns[column.references[0]];
    return ofName(ref && 'sourceField' in ref ? indexPattern === null || indexPattern === void 0 ? void 0 : (_indexPattern$getFiel = indexPattern.getFieldByName(ref.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.displayName : undefined, column.timeScale, column.timeShift);
  },
  toExpression: (layer, columnId) => {
    return (0, _utils.dateBasedOperationToExpression)(layer, columnId, 'lens_counter_rate');
  },
  buildColumn: ({
    referenceIds,
    previousColumn,
    layer,
    indexPattern
  }, columnParams) => {
    var _indexPattern$getFiel2;
    const metric = layer.columns[referenceIds[0]];
    const counterRateColumnParams = columnParams;
    const timeScale = (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale) || (counterRateColumnParams === null || counterRateColumnParams === void 0 ? void 0 : counterRateColumnParams.timeScale) || _time_scale_utils.DEFAULT_TIME_SCALE;
    return {
      label: ofName(metric && 'sourceField' in metric ? (_indexPattern$getFiel2 = indexPattern.getFieldByName(metric.sourceField)) === null || _indexPattern$getFiel2 === void 0 ? void 0 : _indexPattern$getFiel2.displayName : undefined, timeScale, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      dataType: 'number',
      operationType: 'counter_rate',
      isBucketed: false,
      scale: 'ratio',
      references: referenceIds,
      timeScale,
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      params: (0, _helpers.getFormatFromPreviousColumn)(previousColumn)
    };
  },
  isTransferable: (column, newIndexPattern) => {
    return (0, _utils.hasDateField)(newIndexPattern);
  },
  getErrorMessage: (layer, columnId) => {
    return (0, _utils.getErrorsForDateReference)(layer, columnId, _i18n.i18n.translate('xpack.lens.indexPattern.counterRate', {
      defaultMessage: 'Counter rate'
    }));
  },
  getDisabledStatus(indexPattern, layer, layerType) {
    const opName = _i18n.i18n.translate('xpack.lens.indexPattern.counterRate', {
      defaultMessage: 'Counter rate'
    });
    if (layerType) {
      const dataLayerErrors = (0, _utils.checkForDataLayerType)(layerType, opName);
      if (dataLayerErrors) {
        return dataLayerErrors.join(', ');
      }
    }
    return (0, _utils.checkForDateHistogram)(layer, opName).map(e => e.message).join(', ');
  },
  timeScalingMode: 'mandatory',
  filterable: true,
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.counterRate.documentation.quick', {
    defaultMessage: `
      The rate of change over time for an ever growing time series metric.
      `
  }),
  shiftable: true
};