"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useESQLVariables = void 0;
var _react = require("react");
var _uuid = require("uuid");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _types = require("../../../react_embeddable/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useESQLVariables = ({
  parentApi,
  attributes,
  panelId,
  closeFlyout
}) => {
  const dashboardPanels = (0, _presentationPublishing.useStateFromPublishingSubject)((0, _types.isApiESQLVariablesCompatible)(parentApi) ? parentApi === null || parentApi === void 0 ? void 0 : parentApi.children$ : undefined);
  const controlGroupApi = (0, _presentationPublishing.useStateFromPublishingSubject)((0, _types.isApiESQLVariablesCompatible)(parentApi) ? parentApi === null || parentApi === void 0 ? void 0 : parentApi.controlGroupApi$ : undefined);
  const panel = (0, _react.useMemo)(() => {
    if (!panelId) {
      return;
    }
    return dashboardPanels === null || dashboardPanels === void 0 ? void 0 : dashboardPanels[panelId];
  }, [dashboardPanels, panelId]);
  const onSaveControl = (0, _react.useCallback)(async (controlState, updatedQuery) => {
    if (!panelId) {
      return;
    }

    // add a new control
    controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.addNewPanel({
      panelType: 'esqlControl',
      initialState: {
        ...controlState,
        id: (0, _uuid.v4)()
      }
    });
    if (panel && updatedQuery) {
      panel.updateAttributes({
        ...attributes,
        state: {
          ...attributes.state,
          query: {
            esql: updatedQuery
          },
          needsRefresh: true
        }
      });
      // open the edit flyout to continue editing
      await panel.onEdit();
    }
  }, [attributes, controlGroupApi, panel, panelId]);
  const onCancelControl = (0, _react.useCallback)(() => {
    closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
    if (panel) {
      panel.onEdit();
    }
  }, [closeFlyout, panel]);
  return {
    onSaveControl,
    onCancelControl
  };
};
exports.useESQLVariables = useESQLVariables;