"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collapse = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Collapses multiple rows into a single row using the specified function.
 *
 * The `by` argument specifies the columns to group by - these columns are not collapsed.
 * The `metric` arguments specifies the collumns to apply the aggregate function to.
 *
 * All other columns are removed.
 */
const collapse = exports.collapse = {
  name: 'lens_collapse',
  type: 'datatable',
  inputTypes: ['datatable'],
  help: _i18n.i18n.translate('xpack.lens.functions.collapse.help', {
    defaultMessage: 'Collapses multiple rows into a single row using the specified aggregate function.'
  }),
  args: {
    by: {
      help: _i18n.i18n.translate('xpack.lens.functions.collapse.args.byHelpText', {
        defaultMessage: 'Columns to group by - these columns are kept as-is'
      }),
      multi: true,
      types: ['string'],
      required: false
    },
    metric: {
      help: _i18n.i18n.translate('xpack.lens.functions.collapse.args.metricHelpText', {
        defaultMessage: 'Column to calculate the specified aggregate function of'
      }),
      types: ['string'],
      multi: true,
      required: false
    },
    fn: {
      help: _i18n.i18n.translate('xpack.lens.functions.collapse.args.fnHelpText', {
        defaultMessage: 'The aggregate function to apply'
      }),
      types: ['string'],
      multi: true,
      required: true
    }
  },
  async fn(...args) {
    /** Build optimization: prevent adding extra code into initial bundle **/
    const {
      collapseFn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./collapse_fn')));
    return collapseFn(...args);
  }
};