"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsClientBedrockChatModel = void 0;
var _web = require("@langchain/community/chat_models/bedrock/web");
var _bedrock = require("../utils/bedrock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated Use the ActionsClientChatBedrockConverse chat model instead.
 * ActionsClientBedrockChatModel chat model supports non-streaming only the Bedrock Invoke API.
 * The LangChain team will support only the Bedrock Converse API in the future.
 */
class ActionsClientBedrockChatModel extends _web.BedrockChat {
  constructor({
    actionsClient,
    connectorId,
    logger,
    ...params
  }) {
    var _params$model;
    super({
      ...params,
      credentials: {
        accessKeyId: '',
        secretAccessKey: ''
      },
      // only needed to force BedrockChat to use messages api for Claude v2
      model: (_params$model = params.model) !== null && _params$model !== void 0 ? _params$model : _bedrock.DEFAULT_BEDROCK_MODEL,
      region: _bedrock.DEFAULT_BEDROCK_REGION,
      fetchFn: async (url, options) => {
        var _params$telemetryMeta, _params$telemetryMeta2, _params$temperature, _params$maxTokens;
        const inputBody = JSON.parse(options === null || options === void 0 ? void 0 : options.body);
        if (this.streaming) {
          throw new Error(`ActionsClientBedrockChat does not support streaming, use ActionsClientChatBedrockConverse instead`);
        }
        const data = await actionsClient.execute({
          actionId: connectorId,
          params: {
            subAction: 'invokeAIRaw',
            subActionParams: {
              telemetryMetadata: {
                pluginId: params === null || params === void 0 ? void 0 : (_params$telemetryMeta = params.telemetryMetadata) === null || _params$telemetryMeta === void 0 ? void 0 : _params$telemetryMeta.pluginId,
                aggregateBy: params === null || params === void 0 ? void 0 : (_params$telemetryMeta2 = params.telemetryMetadata) === null || _params$telemetryMeta2 === void 0 ? void 0 : _params$telemetryMeta2.aggregateBy
              },
              messages: (0, _bedrock.prepareMessages)(inputBody.messages),
              temperature: (_params$temperature = params.temperature) !== null && _params$temperature !== void 0 ? _params$temperature : inputBody.temperature,
              stopSequences: inputBody.stop_sequences,
              system: inputBody.system,
              maxTokens: (_params$maxTokens = params.maxTokens) !== null && _params$maxTokens !== void 0 ? _params$maxTokens : inputBody.max_tokens,
              tools: inputBody.tools,
              anthropicVersion: inputBody.anthropic_version
            }
          }
        });
        if (data.status === 'error') {
          throw new Error(`ActionsClientBedrockChat: action result status is error: ${data === null || data === void 0 ? void 0 : data.message} - ${data === null || data === void 0 ? void 0 : data.serviceMessage}`);
        }
        return {
          ok: data.status === 'ok',
          json: () => data.data
        };
      }
    });
  }
}
exports.ActionsClientBedrockChatModel = ActionsClientBedrockChatModel;