"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderCompleteListener = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class RenderCompleteListener {
  constructor(element) {
    (0, _defineProperty2.default)(this, "attributeName", 'data-render-complete');
    (0, _defineProperty2.default)(this, "destroy", () => {
      this.element.removeEventListener('renderStart', this.start);
      this.element.removeEventListener('renderComplete', this.complete);
    });
    (0, _defineProperty2.default)(this, "setup", () => {
      this.element.setAttribute(this.attributeName, 'false');
      this.element.addEventListener('renderStart', this.start);
      this.element.addEventListener('renderComplete', this.complete);
    });
    (0, _defineProperty2.default)(this, "disable", () => {
      this.element.setAttribute(this.attributeName, 'disabled');
      this.destroy();
    });
    (0, _defineProperty2.default)(this, "start", () => {
      this.element.setAttribute(this.attributeName, 'false');
      return true;
    });
    (0, _defineProperty2.default)(this, "complete", () => {
      this.element.setAttribute(this.attributeName, 'true');
      return true;
    });
    this.element = element;
    this.setup();
  }
}
exports.RenderCompleteListener = RenderCompleteListener;