"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.itemSchema = exports.investigationItemSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const itemSchema = exports.itemSchema = _zod.z.object({
  title: _zod.z.string(),
  type: _zod.z.string(),
  params: _zod.z.record(_zod.z.string(), _zod.z.any())
});
const investigationItemSchema = exports.investigationItemSchema = _zod.z.intersection(_zod.z.object({
  id: _zod.z.string(),
  createdAt: _zod.z.number(),
  createdBy: _zod.z.string(),
  updatedAt: _zod.z.number()
}), itemSchema);