"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertEvents = getAlertEvents;
exports.getAnnotationEvents = getAnnotationEvents;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _investigationShared = require("@kbn/investigation-shared");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _queries = require("../lib/queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAnnotationEvents(params, annotationsClient) {
  const response = await annotationsClient.find({
    start: params === null || params === void 0 ? void 0 : params.rangeFrom,
    end: params === null || params === void 0 ? void 0 : params.rangeTo,
    filter: params === null || params === void 0 ? void 0 : params.filter,
    size: 100
  });

  // we will return only "point_in_time" annotations
  const events = response.items.filter(item => {
    var _item$event;
    return !((_item$event = item.event) !== null && _item$event !== void 0 && _item$event.end);
  }).map(item => {
    var _item$host, _item$service, _item$service2, _item$slo, _item$slo2;
    const hostName = (_item$host = item.host) === null || _item$host === void 0 ? void 0 : _item$host.name;
    const serviceName = (_item$service = item.service) === null || _item$service === void 0 ? void 0 : _item$service.name;
    const serviceVersion = (_item$service2 = item.service) === null || _item$service2 === void 0 ? void 0 : _item$service2.version;
    const sloId = (_item$slo = item.slo) === null || _item$slo === void 0 ? void 0 : _item$slo.id;
    const sloInstanceId = (_item$slo2 = item.slo) === null || _item$slo2 === void 0 ? void 0 : _item$slo2.instanceId;
    return {
      id: item.id,
      title: item.annotation.title,
      description: item.message,
      timestamp: new Date(item['@timestamp']).getTime(),
      eventType: 'annotation',
      annotationType: item.annotation.type,
      source: {
        ...(hostName ? {
          'host.name': hostName
        } : undefined),
        ...(serviceName ? {
          'service.name': serviceName
        } : undefined),
        ...(serviceVersion ? {
          'service.version': serviceVersion
        } : undefined),
        ...(sloId ? {
          'slo.id': sloId
        } : undefined),
        ...(sloInstanceId ? {
          'slo.instanceId': sloInstanceId
        } : undefined)
      }
    };
  });
  return _investigationShared.annotationEventSchema.array().parse(events);
}
async function getAlertEvents(params, alertsClient) {
  var _params$rangeFrom, _params$rangeTo;
  const startInMs = _datemath.default.parse((_params$rangeFrom = params === null || params === void 0 ? void 0 : params.rangeFrom) !== null && _params$rangeFrom !== void 0 ? _params$rangeFrom : 'now-15m').valueOf();
  const endInMs = _datemath.default.parse((_params$rangeTo = params === null || params === void 0 ? void 0 : params.rangeTo) !== null && _params$rangeTo !== void 0 ? _params$rangeTo : 'now').valueOf();
  const filterJSON = params !== null && params !== void 0 && params.filter ? JSON.parse(params.filter) : {};
  const body = {
    size: 100,
    track_total_hits: false,
    query: {
      bool: {
        filter: [...(0, _queries.rangeQuery)(startInMs, endInMs, _ruleDataUtils.ALERT_START), ...Object.keys(filterJSON).map(filterKey => ({
          term: {
            [filterKey]: filterJSON[filterKey]
          }
        }))]
      }
    }
  };
  const response = await alertsClient.search(body);
  const events = response.hits.hits.map(hit => {
    const _source = hit._source;
    return {
      id: _source[_ruleDataUtils.ALERT_UUID],
      title: `${_source[_ruleDataUtils.ALERT_RULE_CATEGORY]} breached`,
      description: _source[_ruleDataUtils.ALERT_REASON],
      timestamp: new Date(_source[_ruleDataUtils.ALERT_START]).getTime(),
      eventType: 'alert',
      alertStatus: _source[_ruleDataUtils.ALERT_STATUS]
    };
  });
  return _investigationShared.alertEventSchema.array().parse(events);
}