"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findInvestigations = findInvestigations;
var _investigationShared = require("@kbn/investigation-shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findInvestigations(params, repository) {
  const investigations = await repository.search({
    search: toSearch(params),
    filter: toFilter(params),
    pagination: toPagination(params)
  });
  return _investigationShared.findInvestigationsResponseSchema.parse(investigations);
}
function toPagination(params) {
  const DEFAULT_PER_PAGE = 10;
  const DEFAULT_PAGE = 1;
  return {
    page: params !== null && params !== void 0 && params.page && params.page >= 1 ? params.page : DEFAULT_PAGE,
    perPage: params !== null && params !== void 0 && params.perPage && params.perPage > 0 && params.perPage <= 100 ? params.perPage : DEFAULT_PER_PAGE
  };
}
function toSearch(params) {
  if (params !== null && params !== void 0 && params.search) {
    return {
      search: params.search
    };
  }
}
function toFilter(params) {
  if (params !== null && params !== void 0 && params.alertId) {
    const activeStatus = 'active';
    const triageStatus = 'triage';
    return `investigation.attributes.origin.id:(${params.alertId}) AND (investigation.attributes.status: ${activeStatus} OR investigation.attributes.status: ${triageStatus})`;
  }
  if (params !== null && params !== void 0 && params.filter) {
    return params.filter;
  }
}