"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInvestigationNote = createInvestigationNote;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createInvestigationNote(investigationId, params, {
  repository,
  user
}) {
  const investigation = await repository.findById(investigationId);
  const now = Date.now();
  const investigationNote = {
    id: (0, _uuid.v4)(),
    content: params.content,
    createdBy: user.profile_uid,
    updatedAt: now,
    createdAt: now
  };
  investigation.notes.push(investigationNote);
  await repository.save(investigation);
  return investigationNote;
}