"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootCauseAnalysisRoute = void 0;
var _rxjs = require("rxjs");
var _root_cause_analysis = require("@kbn/observability-ai-server/root_cause_analysis");
var _zod = require("@kbn/zod");
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _create_observability_es_client = require("@kbn/observability-utils-server/es/client/create_observability_es_client");
var _boom = require("@hapi/boom");
var _create_investigate_app_server_route = require("../create_investigate_app_server_route");
var _investigation_repository = require("../../services/investigation_repository");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rootCauseAnalysisRoute = exports.rootCauseAnalysisRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'POST /internal/observability/investigation/root_cause_analysis',
  options: {
    tags: []
  },
  params: _zod.z.object({
    body: _zod.z.object({
      investigationId: _zod.z.string(),
      rangeFrom: _zod.z.string(),
      rangeTo: _zod.z.string(),
      serviceName: _zod.z.string(),
      context: _zod.z.string(),
      connectorId: _zod.z.string(),
      completeInBackground: _zod.z.boolean().optional()
    })
  }),
  handler: async ({
    params,
    plugins,
    request,
    context: requestContext,
    logger
  }) => {
    var _datemath$parse, _datemath$parse2, _await$plugins$spaces, _plugins$spaces;
    const {
      body: {
        investigationId,
        context,
        rangeFrom,
        rangeTo,
        serviceName,
        connectorId,
        completeInBackground
      }
    } = params;
    if (!plugins.observabilityAIAssistant) {
      throw (0, _boom.preconditionFailed)('Observability AI Assistant plugin is not available');
    }
    const start = (_datemath$parse = _datemath.default.parse(rangeFrom)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
    const end = (_datemath$parse2 = _datemath.default.parse(rangeTo)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
    const coreContext = await requestContext.core;
    const coreEsClient = coreContext.elasticsearch.client.asCurrentUser;
    const soClient = coreContext.savedObjects.client;
    const uiSettingsClient = coreContext.uiSettings.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    const esClient = (0, _create_observability_es_client.createObservabilityEsClient)({
      client: coreEsClient,
      logger,
      plugin: 'investigateApp'
    });
    const [investigation, rulesClient, alertsClient, inferenceClient, observabilityAIAssistantClient, spaceId = 'default', apmIndices, logSources, sloSummaryIndices] = await Promise.all([repository.findById(investigationId), (await plugins.alerting.start()).getRulesClientWithRequest(request), (await plugins.ruleRegistry.start()).getRacClientWithRequest(request), (await plugins.inference.start()).getClient({
      request
    }), plugins.observabilityAIAssistant.start().then(observabilityAIAssistantStart => observabilityAIAssistantStart.service.getClient({
      request,
      scopes: ['observability']
    })), (_await$plugins$spaces = await ((_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.start())) === null || _await$plugins$spaces === void 0 ? void 0 : _await$plugins$spaces.spacesService.getSpaceId(request), plugins.apmDataAccess.setup.getApmIndices(soClient), uiSettingsClient.get(_managementSettingsIds.OBSERVABILITY_LOGS_DATA_ACCESS_LOG_SOURCES_ID), (await plugins.slo.start()).getSloClientWithRequest(request).getSummaryIndices()]);
    const next$ = (0, _root_cause_analysis.runRootCauseAnalysis)({
      alertsClient,
      connectorId,
      start,
      end,
      esClient,
      inferenceClient,
      indices: {
        logs: logSources,
        traces: [apmIndices.span, apmIndices.error, apmIndices.transaction],
        sloSummaries: sloSummaryIndices
      },
      rulesClient,
      observabilityAIAssistantClient,
      serviceName,
      spaceId,
      context,
      logger
    }).pipe((0, _rxjs.switchMap)(event => {
      return (0, _rxjs.of)({
        type: 'event',
        event
      });
    }));
    if (completeInBackground) {
      const shared$ = next$.pipe((0, _rxjs.share)());
      shared$.pipe((0, _rxjs.toArray)(), (0, _rxjs.catchError)(() => {
        return (0, _rxjs.of)();
      }), (0, _rxjs.switchMap)(events => {
        return (0, _rxjs.from)(repository.save({
          ...investigation,
          rootCauseAnalysis: {
            events: events.map(({
              event
            }) => event)
          }
        }));
      })).subscribe({
        error: error => {
          logger.error(`Failed to update investigation: ${error.message}`);
          logger.error(error);
        }
      });
      return shared$;
    }
    return next$;
  }
});