"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKibanaColumns = getKibanaColumns;
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getKibanaColumns(columns) {
  var _columns$map;
  return (_columns$map = columns.map(({
    name,
    type
  }) => ({
    id: name,
    name,
    meta: {
      type: (0, _fieldTypes.esFieldTypeToKibanaFieldType)(type)
    }
  }))) !== null && _columns$map !== void 0 ? _columns$map : [];
}