"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _constants = require("@kbn/deeplinks-observability/constants");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _api = require("./api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getCreateEsqlService = (0, _lodash.once)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./services/esql'))).then(m => m.createEsqlService));
class InvestigateAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "repositoryClient", void 0);
    this.logger = context.logger.get();
    this.config = context.config.get();
  }
  setup(coreSetup, pluginsSetup) {
    this.repositoryClient = (0, _api.createInvestigateAppRepositoryClient)(coreSetup);
    coreSetup.application.register({
      id: _constants.INVESTIGATE_APP_ID,
      title: _i18n.i18n.translate('xpack.investigateApp.appTitle', {
        defaultMessage: 'Investigations'
      }),
      euiIconType: 'logoObservability',
      appRoute: '/app/investigations',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      status: this.config.enabled ? _public.AppStatus.accessible : _public.AppStatus.inaccessible,
      visibleIn: [],
      deepLinks: [{
        id: 'investigations',
        title: _i18n.i18n.translate('xpack.investigateApp.investigationsDeepLinkTitle', {
          defaultMessage: 'All investigations'
        }),
        path: '/'
      }, {
        id: 'investigationDetails',
        title: _i18n.i18n.translate('xpack.investigateApp.newInvestigateDeepLinkTitle', {
          defaultMessage: 'New investigation'
        }),
        path: '/new'
      }],
      mount: async appMountParameters => {
        // Load application bundle and Get start services
        const [{
          Application
        }, [coreStart, pluginsStart], createEsqlService] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application'))), coreSetup.getStartServices(), getCreateEsqlService()]);
        const services = {
          ...coreStart,
          esql: createEsqlService({
            data: pluginsStart.data,
            dataViews: pluginsStart.dataViews,
            lens: pluginsStart.lens
          }),
          charts: pluginsStart.charts,
          investigateAppRepositoryClient: this.repositoryClient
        };
        _reactDom.default.render(/*#__PURE__*/_react.default.createElement(Application, {
          coreStart: coreStart,
          history: appMountParameters.history,
          pluginsStart: pluginsStart,
          theme$: appMountParameters.theme$,
          services: services
        }), appMountParameters.element);
        return () => {
          _reactDom.default.unmountComponentAtNode(appMountParameters.element);
        };
      }
    });
    const pluginsStartPromise = coreSetup.getStartServices().then(([, pluginsStart]) => pluginsStart);
    Promise.all([pluginsStartPromise, Promise.resolve().then(() => _interopRequireWildcard(require('./items/register_items'))).then(m => m.registerItems), getCreateEsqlService()]).then(([pluginsStart, registerItems, createEsqlService]) => {
      registerItems({
        dependencies: {
          setup: pluginsSetup,
          start: pluginsStart
        },
        services: {
          investigateAppRepositoryClient: this.repositoryClient,
          esql: createEsqlService({
            data: pluginsStart.data,
            dataViews: pluginsStart.dataViews,
            lens: pluginsStart.lens
          }),
          charts: pluginsStart.charts
        }
      });
    });
    return {};
  }
  start(coreStart, pluginsStart) {
    return {};
  }
}
exports.InvestigateAppPlugin = InvestigateAppPlugin;