"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = SearchBar;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _status_filter = require("./status_filter");
var _tags_filter = require("./tags_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_LABEL = _i18n.i18n.translate('xpack.investigateApp.investigationList.searchField.label', {
  defaultMessage: 'Search...'
});
function SearchBar({
  onSearch,
  onStatusFilterChange,
  onTagsFilterChange,
  isLoading
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    isClearable: true,
    "data-test-subj": "investigateAppInvestigationListFieldSearch",
    placeholder: SEARCH_LABEL,
    "aria-label": SEARCH_LABEL,
    onSearch: value => onSearch(value),
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tags_filter.TagsFilter, {
    isLoading: isLoading,
    onChange: onTagsFilterChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_status_filter.StatusFilter, {
    isLoading: isLoading,
    onChange: onStatusFilterChange
  })));
}