"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationList = InvestigationList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _paths = require("../../../../common/paths");
var _investigation_status_badge = require("../../../components/investigation_status_badge/investigation_status_badge");
var _investigation_tag = require("../../../components/investigation_tag/investigation_tag");
var _use_fetch_investigation_list = require("../../../hooks/use_fetch_investigation_list");
var _use_fetch_user_profiles = require("../../../hooks/use_fetch_user_profiles");
var _use_kibana = require("../../../hooks/use_kibana");
var _investigation_list_actions = require("./investigation_list_actions");
var _investigation_stats = require("./investigation_stats");
var _investigations_error = require("./investigations_error");
var _search_bar = require("./search_bar/search_bar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationList() {
  var _data$results, _data$total;
  const {
    core: {
      http: {
        basePath
      },
      uiSettings
    }
  } = (0, _use_kibana.useKibana)();
  const dateFormat = uiSettings.get('dateFormat');
  const tz = uiSettings.get('dateFormat:tz');
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [search, setSearch] = (0, _react.useState)(undefined);
  const [status, setStatus] = (0, _react.useState)([]);
  const [tags, setTags] = (0, _react.useState)([]);
  const {
    data,
    isLoading,
    isError
  } = (0, _use_fetch_investigation_list.useFetchInvestigationList)({
    page: pageIndex + 1,
    perPage: pageSize,
    search,
    filter: toFilter(status, tags)
  });
  const {
    data: userProfiles,
    isLoading: isUserProfilesLoading
  } = (0, _use_fetch_user_profiles.useFetchUserProfiles)({
    profileIds: new Set(data === null || data === void 0 ? void 0 : data.results.map(i => i.createdBy))
  });
  const investigations = (_data$results = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results !== void 0 ? _data$results : [];
  const totalItemCount = (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0;
  const columns = [{
    field: 'title',
    name: _i18n.i18n.translate('xpack.investigateApp.investigationList.titleLabel', {
      defaultMessage: 'Name'
    }),
    render: (title, investigation) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "investigateAppInvestigationListDirectLink",
        href: basePath.prepend(_paths.paths.investigationDetails(investigation.id))
      }, title);
    }
  }, {
    field: 'createdBy',
    name: _i18n.i18n.translate('xpack.investigateApp.investigationList.createdByLabel', {
      defaultMessage: 'Created by'
    }),
    truncateText: true,
    render: value => {
      var _ref, _userProfiles$value$u, _userProfiles$value, _userProfiles$value2, _ref2, _userProfiles$value$u2, _userProfiles$value3, _userProfiles$value4;
      return isUserProfilesLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        direction: "row"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: (_ref = (_userProfiles$value$u = userProfiles === null || userProfiles === void 0 ? void 0 : (_userProfiles$value = userProfiles[value]) === null || _userProfiles$value === void 0 ? void 0 : _userProfiles$value.user.full_name) !== null && _userProfiles$value$u !== void 0 ? _userProfiles$value$u : userProfiles === null || userProfiles === void 0 ? void 0 : (_userProfiles$value2 = userProfiles[value]) === null || _userProfiles$value2 === void 0 ? void 0 : _userProfiles$value2.user.username) !== null && _ref !== void 0 ? _ref : value,
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, (_ref2 = (_userProfiles$value$u2 = userProfiles === null || userProfiles === void 0 ? void 0 : (_userProfiles$value3 = userProfiles[value]) === null || _userProfiles$value3 === void 0 ? void 0 : _userProfiles$value3.user.full_name) !== null && _userProfiles$value$u2 !== void 0 ? _userProfiles$value$u2 : userProfiles === null || userProfiles === void 0 ? void 0 : (_userProfiles$value4 = userProfiles[value]) === null || _userProfiles$value4 === void 0 ? void 0 : _userProfiles$value4.user.username) !== null && _ref2 !== void 0 ? _ref2 : value));
    }
  }, {
    field: 'tags',
    name: _i18n.i18n.translate('xpack.investigateApp.investigationList.tagsLabel', {
      defaultMessage: 'Tags'
    }),
    render: value => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        gutterSize: "xs"
      }, value.map(tag => /*#__PURE__*/_react.default.createElement(_investigation_tag.InvestigationTag, {
        key: tag,
        tag: tag
      })));
    }
  }, {
    field: 'notes',
    name: _i18n.i18n.translate('xpack.investigateApp.investigationList.notesLabel', {
      defaultMessage: 'Comments'
    }),
    render: notes => /*#__PURE__*/_react.default.createElement("span", null, (notes === null || notes === void 0 ? void 0 : notes.length) || 0)
  }, {
    field: 'updatedAt',
    name: _i18n.i18n.translate('xpack.investigateApp.investigationList.updatedAtLabel', {
      defaultMessage: 'Updated at'
    }),
    render: updatedAt => /*#__PURE__*/_react.default.createElement("span", null, (0, _moment.default)(updatedAt).tz(tz).format(dateFormat))
  }, {
    field: 'status',
    name: 'Status',
    render: s => {
      return /*#__PURE__*/_react.default.createElement(_investigation_status_badge.InvestigationStatusBadge, {
        status: s
      });
    }
  }, {
    name: 'Actions',
    render: investigation => /*#__PURE__*/_react.default.createElement(_investigation_list_actions.InvestigationListActions, {
      investigation: investigation
    })
  }];
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount,
    pageSizeOptions: [10, 25, 50, 100],
    showPerPageOptions: true
  };
  const resultsCount = pageSize === 0 ? _i18n.i18n.translate('xpack.investigateApp.investigationList.allLabel', {
    defaultMessage: 'Showing All'
  }) : _i18n.i18n.translate('xpack.investigateApp.investigationList.showingLabel', {
    defaultMessage: 'Showing {startItem}-{endItem} of {totalItemCount}',
    values: {
      startItem: pageSize * pageIndex + 1,
      endItem: pageSize * pageIndex + pageSize,
      totalItemCount
    }
  });
  const onTableChange = ({
    page
  }) => {
    if (page) {
      const {
        index,
        size
      } = page;
      setPageIndex(index);
      setPageSize(size);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_investigation_stats.InvestigationStats, null), /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    isLoading: isLoading,
    onSearch: value => setSearch(value),
    onStatusFilterChange: selected => setStatus(selected),
    onTagsFilterChange: selected => setTags(selected)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }), isError && /*#__PURE__*/_react.default.createElement(_investigations_error.InvestigationsError, null), !isLoading && !isError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, resultsCount), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: _i18n.i18n.translate('xpack.investigateApp.investigationList.tableCaption', {
      defaultMessage: 'Investigations List'
    }),
    items: investigations,
    pagination: pagination,
    rowHeader: "title",
    columns: columns,
    onChange: onTableChange
  }))));
}
function toFilter(status, tags) {
  const statusFitler = status.map(s => `investigation.attributes.status:${s}`).join(' OR ');
  const tagsFilter = tags.map(tag => `investigation.attributes.tags:${tag}`).join(' OR ');
  if (statusFitler && tagsFilter) {
    return `(${statusFitler}) AND (${tagsFilter})`;
  }
  if (statusFitler) {
    return statusFitler;
  }
  if (tagsFilter) {
    return tagsFilter;
  }
}