"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationTimelineFilterBar = InvestigationTimelineFilterBar;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = _interopRequireDefault(require("react"));
var _investigation_context = require("../../../contexts/investigation_context");
var _investigation_event_types_filter = require("./investigation_event_types_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationTimelineFilterBar({
  onEventTypesSelected
}) {
  const {
    globalParams,
    updateInvestigationParams
  } = (0, _investigation_context.useInvestigation)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    css: (0, _react.css)`
        padding: 8px 8px 0px 8px;
        max-height: fit-content;
      `
  }, /*#__PURE__*/_react2.default.createElement(_investigation_event_types_filter.InvestigationEventTypesFilter, {
    onSelected: onEventTypesSelected
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiDatePickerRange, {
    compressed: true,
    startDateControl: /*#__PURE__*/_react2.default.createElement(_eui.EuiDatePicker, {
      selected: (0, _moment.default)(globalParams.timeRange.from),
      onChange: date => {
        if (!date) return;
        updateInvestigationParams({
          timeRange: {
            from: date.toISOString(),
            to: globalParams.timeRange.to
          }
        });
      },
      showTimeSelect: true
    }),
    endDateControl: /*#__PURE__*/_react2.default.createElement(_eui.EuiDatePicker, {
      selected: (0, _moment.default)(globalParams.timeRange.to),
      onChange: date => {
        if (!date) return;
        updateInvestigationParams({
          timeRange: {
            from: globalParams.timeRange.from,
            to: date.toISOString()
          }
        });
      },
      showTimeSelect: true
    })
  }));
}