"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsTimeline = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _public = require("@kbn/charts-plugin/public");
var _utils = require("@kbn/observability-utils-browser/chart/utils");
var _std = require("@kbn/std");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_events = require("../../../../../hooks/use_fetch_events");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _investigation_context = require("../../../contexts/investigation_context");
var _alert_event = require("./alert_event");
var _annotation_event = require("./annotation_event");
var _timeline_theme = require("./timeline_theme");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventsTimeline = ({
  eventTypes
}) => {
  const {
    dependencies
  } = (0, _use_kibana.useKibana)();
  const baseTheme = dependencies.start.charts.theme.useChartsBaseTheme();
  const {
    globalParams,
    updateInvestigationParams
  } = (0, _investigation_context.useInvestigation)();
  const chartRef = (0, _react.useRef)(null);
  const {
    data: events,
    isLoading
  } = (0, _use_fetch_events.useFetchEvents)({
    rangeFrom: globalParams.timeRange.from,
    rangeTo: globalParams.timeRange.to,
    eventTypes
  });
  const handleCursorUpdate = (0, _public.useActiveCursor)(dependencies.start.charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const data = (0, _react.useMemo)(() => {
    const points = [{
      x: (0, _moment.default)(globalParams.timeRange.from).valueOf(),
      y: 0
    }, {
      x: (0, _moment.default)(globalParams.timeRange.to).valueOf(),
      y: 0
    }];

    // adding 100 fake points to the chart so the chart shows cursor on hover
    for (let i = 0; i < 100; i++) {
      const diff = (0, _moment.default)(globalParams.timeRange.to).valueOf() - (0, _moment.default)(globalParams.timeRange.from).valueOf();
      points.push({
        x: (0, _moment.default)(globalParams.timeRange.from).valueOf() + diff / 100 * i,
        y: 0
      });
    }
    return points;
  }, [globalParams.timeRange.from, globalParams.timeRange.to]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null);
  }
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: ['100%', 64],
    ref: chartRef
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    xDomain: {
      min: (0, _moment.default)(globalParams.timeRange.from).valueOf(),
      max: (0, _moment.default)(globalParams.timeRange.to).valueOf()
    },
    theme: _timeline_theme.TIMELINE_THEME,
    baseTheme: baseTheme,
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    onBrushEnd: brush => {
      const {
        from,
        to
      } = (0, _utils.getBrushData)(brush);
      updateInvestigationParams({
        timeRange: {
          from,
          to
        }
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y",
    position: _charts.Position.Left,
    hide: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x",
    position: _charts.Position.Bottom,
    tickFormat: d => (0, _moment.default)(d).format('LTS'),
    style: {
      tickLine: {
        visible: true,
        strokeWidth: 1,
        stroke: '#98A2B3'
      }
    }
  }), events === null || events === void 0 ? void 0 : events.map(event => {
    if (event.eventType === 'alert') {
      return /*#__PURE__*/_react.default.createElement(_alert_event.AlertEvent, {
        key: event.id,
        event: event
      });
    }
    if (event.eventType === 'annotation') {
      return /*#__PURE__*/_react.default.createElement(_annotation_event.AnnotationEvent, {
        key: event.id,
        event: event
      });
    }
    (0, _std.assertNever)(event);
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "Time",
    xScaleType: _charts.ScaleType.Time,
    xAccessor: "x",
    yAccessors: ['y'],
    data: data,
    filterSeriesInTooltip: () => false
  }));
};
exports.EventsTimeline = EventsTimeline;