"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResizableTextInput = ResizableTextInput;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ResizableTextInput({
  disabled,
  value,
  onChange,
  onSubmit,
  placeholder
}) {
  const textAreaRef = (0, _react.useRef)(null);
  const handleChange = event => {
    handleResizeTextArea();
    onChange(event.target.value);
  };
  const handleResizeTextArea = (0, _react.useCallback)(() => {
    if (textAreaRef.current) {
      var _textAreaRef$current;
      textAreaRef.current.style.minHeight = 'auto';
      const cappedHeight = Math.min((_textAreaRef$current = textAreaRef.current) === null || _textAreaRef$current === void 0 ? void 0 : _textAreaRef$current.scrollHeight, 350);
      textAreaRef.current.style.minHeight = cappedHeight + 'px';
    }
  }, []);
  (0, _react.useEffect)(() => {
    const textarea = textAreaRef.current;
    if (textarea) {
      textarea.focus();
    }
  }, []);
  (0, _react.useEffect)(() => {
    handleResizeTextArea();
  }, [handleResizeTextArea]);
  (0, _react.useEffect)(() => {
    if (value === undefined) {
      handleResizeTextArea();
    }
  }, [handleResizeTextArea, value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "investigateAppResizableTextInputTextArea",
    className: (0, _css.css)`
        max-height: 350px;
        padding: 8px 12px;
      `,
    disabled: disabled,
    fullWidth: true,
    inputRef: textAreaRef,
    placeholder: placeholder,
    resize: "vertical",
    rows: 4,
    value: value,
    onChange: handleChange,
    onKeyDown: event => {
      if (!event.shiftKey && event.key === _eui.keys.ENTER) {
        event.preventDefault();
        onSubmit();
      }
    }
  });
}