"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInvestigationItem = AddInvestigationItem;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _public = require("@kbn/esql/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _investigation_context = require("../../contexts/investigation_context");
var _add_from_library_button = require("../add_from_library_button");
var _esql_widget_preview = require("./esql_widget_preview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyPreview = (0, _css.css)`
  padding: 36px 0px 36px 0px;
`;
function AddInvestigationItem() {
  const {
    addItem,
    globalParams
  } = (0, _investigation_context.useInvestigation)();
  const [isOpen, setIsOpen] = _react.default.useState(false);
  const [query, setQuery] = _react.default.useState({
    esql: ''
  });
  const [submittedQuery, setSubmittedQuery] = _react.default.useState({
    esql: ''
  });
  const [isPreviewOpen, setIsPreviewOpen] = _react.default.useState(false);
  const resetState = () => {
    setIsPreviewOpen(false);
    setQuery({
      esql: ''
    });
    setSubmittedQuery({
      esql: ''
    });
  };
  if (!isOpen) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      direction: "row",
      alignItems: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "investigateAppAddObservationUIAddAnObservationChartButton",
      iconType: "plusInCircle",
      onClick: () => setIsOpen(true)
    }, _i18n.i18n.translate('xpack.investigateApp.addObservationUI.addAnObservationChartButtonLabel', {
      defaultMessage: 'Add an observation chart'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.investigateApp.addObservationUI.h2.addAnObservationChartLabel', {
    defaultMessage: 'Add an observation chart'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.ESQLLangEditor, {
    query: query,
    onTextLangQueryChange: setQuery,
    onTextLangQuerySubmit: async nextSubmittedQuery => {
      if (nextSubmittedQuery) {
        setSubmittedQuery(nextSubmittedQuery);
        setIsPreviewOpen(true);
      }
    },
    errors: undefined,
    warning: undefined,
    editorIsInline: false,
    hideRunQueryText: true,
    isLoading: false,
    disableSubmitAction: true,
    isDisabled: false,
    hideTimeFilterInfo: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_from_library_button.AddFromLibraryButton, {
    onItemAdd: async item => {
      resetState();
      await addItem(item);
    }
  }))), !isPreviewOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    gutterSize: "l",
    className: emptyPreview
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "image",
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.investigateApp.addObservationUI.p.selectADataSourceLabel', {
    defaultMessage: 'Select a data source to generate a preview chart'
  })))) : /*#__PURE__*/_react.default.createElement(_esql_widget_preview.EsqlWidgetPreview, {
    esqlQuery: submittedQuery.esql,
    timeRange: globalParams.timeRange,
    onItemAdd: async item => {
      resetState();
      await addItem(item);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    "data-test-subj": "investigateAppAddObservationUICancelButton",
    onClick: () => {
      resetState();
      setIsOpen(false);
    }
  }, _i18n.i18n.translate('xpack.investigateApp.addObservationUI.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))))));
}